/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import shaded.org.bouncycastle.crypto.agreement.SM2KeyExchange;
import shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import shaded.org.bouncycastle.crypto.params.ParametersWithID;
import shaded.org.bouncycastle.crypto.params.SM2KeyExchangePrivateParameters;
import shaded.org.bouncycastle.crypto.params.SM2KeyExchangePublicParameters;
import shaded.org.bouncycastle.tls.crypto.TlsSecret;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsECDH;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsECDomain;

public class BcTlsECDHE_SM2
extends BcTlsECDH {
    private static final byte[] SM2_ID = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
    private ECPublicKeyParameters myStaticPublicKey;
    private ECPrivateKeyParameters myStaticPrivateKey;
    private ECPublicKeyParameters peerStaticPublicKey;

    public BcTlsECDHE_SM2(BcTlsECDomain domain) {
        super(domain);
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        SM2KeyExchange sm2KeyExchange = new SM2KeyExchange();
        SM2KeyExchangePrivateParameters sm2KeyExchangePrivateParameters = new SM2KeyExchangePrivateParameters(true, this.myStaticPrivateKey, (ECPrivateKeyParameters)this.localKeyPair.getPrivate());
        sm2KeyExchange.init(new ParametersWithID(sm2KeyExchangePrivateParameters, SM2_ID));
        SM2KeyExchangePublicParameters sm2KeyExchangePublicParameters = new SM2KeyExchangePublicParameters(this.peerStaticPublicKey, this.peerPublicKey);
        byte[] S = sm2KeyExchange.calculateKey(128, new ParametersWithID(sm2KeyExchangePublicParameters, SM2_ID));
        return this.domain.crypto.adoptLocalSecret(S);
    }
}

