/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.crypto.impl.bc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import shaded.org.bouncycastle.asn1.x509.Certificate;
import shaded.org.bouncycastle.asn1.x509.Extension;
import shaded.org.bouncycastle.asn1.x509.Extensions;
import shaded.org.bouncycastle.asn1.x509.KeyUsage;
import shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shaded.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import shaded.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import shaded.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import shaded.org.bouncycastle.crypto.util.PublicKeyFactory;
import shaded.org.bouncycastle.jcajce.util.JcaJceHelper;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.crypto.TlsCertificate;
import shaded.org.bouncycastle.tls.crypto.TlsCryptoException;
import shaded.org.bouncycastle.tls.crypto.TlsVerifier;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsDSAVerifier;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSAVerifier;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAVerifier;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsSM2Verifier;
import shaded.org.bouncycastle.util.Arrays;

public class BcTlsCertificate
implements TlsCertificate {
    protected final BcTlsCrypto crypto;
    protected final Certificate certificate;
    protected final X509Certificate x509Certificate;
    protected DHPublicKeyParameters pubKeyDH = null;
    protected ECPublicKeyParameters pubKeyEC = null;
    protected RSAKeyParameters pubKeyRSA = null;

    public static BcTlsCertificate convert(BcTlsCrypto crypto, TlsCertificate certificate) throws IOException {
        if (certificate instanceof BcTlsCertificate) {
            return (BcTlsCertificate)certificate;
        }
        return new BcTlsCertificate(crypto, certificate.getEncoded());
    }

    public static Certificate parseCertificate(byte[] encoding) throws IOException {
        try {
            return Certificate.getInstance(encoding);
        }
        catch (IllegalArgumentException e) {
            throw new TlsCryptoException("unable to decode certificate: " + e.getMessage(), e);
        }
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public static X509Certificate parseX509Certificate(JcaJceHelper helper, byte[] encoding) throws IOException {
        try {
            byte[] derEncoding = Certificate.getInstance(encoding).getEncoded("DER");
            ByteArrayInputStream input = new ByteArrayInputStream(derEncoding);
            X509Certificate certificate = (X509Certificate)helper.createCertificateFactory("X.509").generateCertificate(input);
            if (input.available() != 0) {
                throw new IOException("Extra data detected in stream");
            }
            return certificate;
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("unable to decode certificate", e);
        }
    }

    public BcTlsCertificate(BcTlsCrypto crypto, byte[] encoding) throws IOException {
        this(crypto, BcTlsCertificate.parseCertificate(encoding));
    }

    public BcTlsCertificate(BcTlsCrypto crypto, Certificate certificate) throws IOException {
        this.crypto = crypto;
        this.certificate = certificate;
        this.x509Certificate = BcTlsCertificate.parseX509Certificate(crypto.getHelper(), certificate.getEncoded());
    }

    @Override
    public TlsVerifier createVerifier(short signatureAlgorithm) throws IOException {
        this.validateKeyUsage(128);
        switch (signatureAlgorithm) {
            case 2: {
                return new BcTlsDSAVerifier(this.crypto, this.getPubKeyDSS());
            }
            case 3: {
                return new BcTlsECDSAVerifier(this.crypto, this.getPubKeyEC());
            }
            case 1: {
                return new BcTlsRSAVerifier(this.crypto, this.getPubKeyRSA());
            }
            case 4: {
                return new BcTlsSM2Verifier(this.crypto, this.getPubKeyEC());
            }
        }
        throw new TlsFatalAlert(46);
    }

    @Override
    public short getClientCertificateType() throws IOException {
        AsymmetricKeyParameter publicKey = this.getPublicKey();
        if (publicKey.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        try {
            if (publicKey instanceof RSAKeyParameters) {
                this.validateKeyUsage(128);
                return 1;
            }
            if (publicKey instanceof DSAPublicKeyParameters) {
                this.validateKeyUsage(128);
                return 2;
            }
            if (publicKey instanceof ECPublicKeyParameters) {
                ECNamedDomainParameters ecNamedDomainParameters;
                ASN1ObjectIdentifier asn1ObjectIdentifier;
                this.validateKeyUsage(128);
                ECPublicKeyParameters ecPublicKeyParameters = (ECPublicKeyParameters)publicKey;
                ECDomainParameters ecDomainParameters = ecPublicKeyParameters.getParameters();
                if (ecDomainParameters instanceof ECNamedDomainParameters && (asn1ObjectIdentifier = (ecNamedDomainParameters = (ECNamedDomainParameters)ecDomainParameters).getName()).equals(GMObjectIdentifiers.sm2p256v1)) {
                    return 81;
                }
                return 64;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
        throw new TlsFatalAlert(43);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.certificate.getEncoded("DER");
    }

    @Override
    public byte[] getExtension(ASN1ObjectIdentifier extensionOID) throws IOException {
        Extension extension;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (extension = extensions.getExtension(extensionOID)) != null) {
            return Arrays.clone(extension.getExtnValue().getOctets());
        }
        return null;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber().getValue();
    }

    protected DHPublicKeyParameters getPubKeyDH() throws IOException {
        try {
            return (DHPublicKeyParameters)this.getPublicKey();
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    public DSAPublicKeyParameters getPubKeyDSS() throws IOException {
        DSAPublicKeyParameters pubKeyDSS;
        try {
            pubKeyDSS = (DSAPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
        return this.validatePubKeyDSS(pubKeyDSS);
    }

    public ECPublicKeyParameters getPubKeyEC() throws IOException {
        ECPublicKeyParameters pubKeyEC;
        try {
            pubKeyEC = (ECPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
        return this.validatePubKeyEC(pubKeyEC);
    }

    public RSAKeyParameters getPubKeyRSA() throws IOException {
        RSAKeyParameters pubKeyRSA;
        try {
            pubKeyRSA = (RSAKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
        return this.validatePubKeyRSA(pubKeyRSA);
    }

    @Override
    public TlsCertificate useInRole(int connectionEnd, int keyExchangeAlgorithm) throws IOException {
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 9: {
                this.validateKeyUsage(8);
                this.pubKeyDH = this.getPubKeyDH();
                return this;
            }
            case 16: 
            case 18: 
            case 25: {
                this.validateKeyUsage(8);
                this.pubKeyEC = this.getPubKeyEC();
                return this;
            }
        }
        if (connectionEnd == 0) {
            switch (keyExchangeAlgorithm) {
                case 1: 
                case 15: {
                    this.validateKeyUsage(32);
                    this.pubKeyRSA = this.getPubKeyRSA();
                    return this;
                }
                case 26: {
                    this.validateKeyUsage(32);
                    this.pubKeyEC = this.getPubKeyEC();
                    return this;
                }
            }
        }
        throw new TlsFatalAlert(46);
    }

    protected AsymmetricKeyParameter getPublicKey() throws IOException {
        SubjectPublicKeyInfo keyInfo = this.certificate.getSubjectPublicKeyInfo();
        try {
            return PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
    }

    protected void validateKeyUsage(int keyUsageBits) throws IOException {
        int bits;
        KeyUsage ku;
        Extensions exts = this.certificate.getTBSCertificate().getExtensions();
        if (exts != null && (ku = KeyUsage.fromExtensions(exts)) != null && ((bits = ku.getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
            throw new TlsFatalAlert(46);
        }
    }

    protected DSAPublicKeyParameters validatePubKeyDSS(DSAPublicKeyParameters pubKeyDSS) throws IOException {
        return pubKeyDSS;
    }

    protected ECPublicKeyParameters validatePubKeyEC(ECPublicKeyParameters pubKeyEC) throws IOException {
        return pubKeyEC;
    }

    protected RSAKeyParameters validatePubKeyRSA(RSAKeyParameters pubKeyRSA) throws IOException {
        return pubKeyRSA;
    }
}

