/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls;

import shaded.org.bouncycastle.tls.SessionParameters;
import shaded.org.bouncycastle.tls.TlsSession;
import shaded.org.bouncycastle.util.Arrays;

class TlsSessionImpl
implements TlsSession {
    final byte[] sessionID;
    final SessionParameters sessionParameters;
    boolean resumable;

    TlsSessionImpl(byte[] sessionID, SessionParameters sessionParameters) {
        if (sessionID == null) {
            throw new IllegalArgumentException("'sessionID' cannot be null");
        }
        if (sessionID.length > 32) {
            throw new IllegalArgumentException("'sessionID' cannot be longer than 32 bytes");
        }
        this.sessionID = Arrays.clone(sessionID);
        this.sessionParameters = sessionParameters;
        this.resumable = sessionID.length > 0;
    }

    @Override
    public synchronized SessionParameters exportSessionParameters() {
        return this.sessionParameters == null ? null : this.sessionParameters.copy();
    }

    @Override
    public synchronized byte[] getSessionID() {
        return this.sessionID;
    }

    @Override
    public synchronized void invalidate() {
        this.resumable = false;
    }

    @Override
    public synchronized boolean isResumable() {
        return this.resumable;
    }
}

