/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls;

import java.io.IOException;
import java.io.OutputStream;
import shaded.org.bouncycastle.tls.TlsContext;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.TlsCertificate;
import shaded.org.bouncycastle.tls.crypto.TlsSecret;

public abstract class TlsRSAUtils {
    private TlsRSAUtils() {
    }

    public static TlsSecret generateEncryptedPreMasterSecret(TlsContext context, TlsCertificate certificate, OutputStream output) throws IOException {
        TlsSecret preMasterSecret = context.getCrypto().generateRSAPreMasterSecret(context.getClientVersion());
        byte[] encryptedPreMasterSecret = preMasterSecret.encrypt(certificate);
        TlsUtils.writeOpaque16(encryptedPreMasterSecret, output);
        return preMasterSecret;
    }
}

