/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import shaded.org.bouncycastle.tls.AbstractTlsKeyExchange;
import shaded.org.bouncycastle.tls.Certificate;
import shaded.org.bouncycastle.tls.TlsCredentialedAgreement;
import shaded.org.bouncycastle.tls.TlsCredentials;
import shaded.org.bouncycastle.tls.TlsECCUtils;
import shaded.org.bouncycastle.tls.TlsECConfigVerifier;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.TlsAgreement;
import shaded.org.bouncycastle.tls.crypto.TlsCertificate;
import shaded.org.bouncycastle.tls.crypto.TlsECConfig;
import shaded.org.bouncycastle.tls.crypto.TlsSecret;

public class TlsECDHKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsECConfigVerifier ecConfigVerifier;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected TlsCredentialedAgreement agreementCredentials;
    protected TlsCertificate ecdhPeerCertificate;
    protected TlsECConfig ecConfig;
    protected TlsAgreement agreement;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsECDHKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfigVerifier ecConfigVerifier, short[] clientECPointFormats, short[] serverECPointFormats) {
        this(keyExchange, supportedSignatureAlgorithms, ecConfigVerifier, null, clientECPointFormats, serverECPointFormats);
    }

    public TlsECDHKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfig ecConfig, short[] serverECPointFormats) {
        this(keyExchange, supportedSignatureAlgorithms, null, ecConfig, null, serverECPointFormats);
    }

    private TlsECDHKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfigVerifier ecConfigVerifier, TlsECConfig ecConfig, short[] clientECPointFormats, short[] serverECPointFormats) {
        super(TlsECDHKeyExchange.checkKeyExchange(keyExchange), supportedSignatureAlgorithms);
        this.ecConfigVerifier = ecConfigVerifier;
        this.ecConfig = ecConfig;
        this.clientECPointFormats = clientECPointFormats;
        this.serverECPointFormats = serverECPointFormats;
    }

    @Override
    public void skipServerCredentials() throws IOException {
        if (this.keyExchange != 20) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (this.keyExchange == 20) {
            throw new TlsFatalAlert(80);
        }
        if (!(serverCredentials instanceof TlsCredentialedAgreement)) {
            throw new TlsFatalAlert(80);
        }
        this.agreementCredentials = (TlsCredentialedAgreement)serverCredentials;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.keyExchange == 20) {
            throw new TlsFatalAlert(10);
        }
        this.checkServerCertSigAlg(serverCertificate);
        this.ecdhPeerCertificate = this.validatePeerCertificate(0, serverCertificate);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        switch (this.keyExchange) {
            case 17: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (!this.requiresServerKeyExchange()) {
            return null;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsECCUtils.writeECConfig(this.ecConfig, buf);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.generateEphemeral(buf);
        return buf.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        if (!this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
        this.ecConfig = TlsECCUtils.receiveECConfig(this.ecConfigVerifier, this.serverECPointFormats, input);
        byte[] point = TlsUtils.readOpaque8(input);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.processEphemeral(this.clientECPointFormats, point);
    }

    @Override
    public short[] getClientCertificateTypes() {
        if (this.keyExchange == 20) {
            return null;
        }
        return new short[]{66, 65};
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (this.keyExchange == 20) {
            throw new TlsFatalAlert(80);
        }
        if (!(clientCredentials instanceof TlsCredentialedAgreement)) {
            throw new TlsFatalAlert(80);
        }
        this.agreementCredentials = (TlsCredentialedAgreement)clientCredentials;
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        if (this.agreementCredentials == null) {
            this.generateEphemeral(output);
        }
    }

    @Override
    public void processClientCertificate(Certificate clientCertificate) throws IOException {
        if (this.keyExchange == 20) {
            throw new TlsFatalAlert(10);
        }
        if (this.agreementCredentials != null) {
            this.ecdhPeerCertificate = this.validatePeerCertificate(1, clientCertificate);
        }
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        if (this.ecdhPeerCertificate != null) {
            return;
        }
        byte[] point = TlsUtils.readOpaque8(input);
        this.processEphemeral(this.serverECPointFormats, point);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        if (this.agreementCredentials != null) {
            return this.agreementCredentials.generateAgreement(this.ecdhPeerCertificate);
        }
        if (this.agreement != null) {
            return this.agreement.calculateSecret();
        }
        throw new TlsFatalAlert(80);
    }

    protected void generateEphemeral(OutputStream output) throws IOException {
        byte[] point = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque8(point, output);
    }

    protected void processEphemeral(short[] localECPointFormats, byte[] point) throws IOException {
        TlsECCUtils.checkPointEncoding(localECPointFormats, this.ecConfig.getNamedGroup(), point);
        this.agreement.receivePeerValue(point);
    }

    protected TlsCertificate validatePeerCertificate(int connectionEnd, Certificate peerCertificate) throws IOException {
        if (peerCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        return peerCertificate.getCertificateAt(0).useInRole(connectionEnd, this.keyExchange);
    }
}

