/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import shaded.org.bouncycastle.tls.NamedGroup;
import shaded.org.bouncycastle.tls.TlsDHConfigVerifier;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.DHGroup;
import shaded.org.bouncycastle.tls.crypto.DHStandardGroups;
import shaded.org.bouncycastle.tls.crypto.TlsDHConfig;
import shaded.org.bouncycastle.util.BigIntegers;

public class TlsDHUtils {
    public static boolean containsDHECipherSuites(int[] cipherSuites) {
        for (int i = 0; i < cipherSuites.length; ++i) {
            if (!TlsDHUtils.isDHECipherSuite(cipherSuites[i])) continue;
            return true;
        }
        return false;
    }

    public static TlsDHConfig createNamedDHConfig(int namedGroup) {
        return NamedGroup.getFiniteFieldBits(namedGroup) > 0 ? new TlsDHConfig(namedGroup) : null;
    }

    public static DHGroup getDHGroup(TlsDHConfig dhConfig) {
        int namedGroup = dhConfig.getNamedGroup();
        if (namedGroup >= 0) {
            return TlsDHUtils.getNamedDHGroup(namedGroup);
        }
        return dhConfig.getExplicitGroup();
    }

    public static DHGroup getNamedDHGroup(int namedGroup) {
        switch (namedGroup) {
            case 256: {
                return DHStandardGroups.rfc7919_ffdhe2048;
            }
            case 257: {
                return DHStandardGroups.rfc7919_ffdhe3072;
            }
            case 258: {
                return DHStandardGroups.rfc7919_ffdhe4096;
            }
            case 259: {
                return DHStandardGroups.rfc7919_ffdhe6144;
            }
            case 260: {
                return DHStandardGroups.rfc7919_ffdhe8192;
            }
        }
        return null;
    }

    public static int getMinimumFiniteFieldBits(int cipherSuite) {
        return TlsDHUtils.isDHECipherSuite(cipherSuite) ? 1 : 0;
    }

    public static boolean isDHECipherSuite(int cipherSuite) {
        switch (TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static int getNamedGroupForDHParameters(BigInteger p, BigInteger g) {
        int[] namedGroups = new int[]{256, 257, 258, 259, 260};
        for (int i = 0; i < namedGroups.length; ++i) {
            int namedGroup = namedGroups[i];
            DHGroup dhGroup = TlsDHUtils.getNamedDHGroup(namedGroup);
            if (dhGroup == null || !dhGroup.getP().equals(p) || !dhGroup.getG().equals(g)) continue;
            return namedGroup;
        }
        return -1;
    }

    public static TlsDHConfig readDHConfig(InputStream input) throws IOException {
        BigInteger g;
        BigInteger p = TlsDHUtils.readDHParameter(input);
        int namedGroup = TlsDHUtils.getNamedGroupForDHParameters(p, g = TlsDHUtils.readDHParameter(input));
        if (namedGroup >= 0) {
            return new TlsDHConfig(namedGroup);
        }
        return new TlsDHConfig(new DHGroup(p, null, g, 0));
    }

    public static TlsDHConfig receiveDHConfig(TlsDHConfigVerifier dhConfigVerifier, InputStream input) throws IOException {
        TlsDHConfig dhConfig = TlsDHUtils.readDHConfig(input);
        if (!dhConfigVerifier.accept(dhConfig)) {
            throw new TlsFatalAlert(71);
        }
        return dhConfig;
    }

    public static BigInteger readDHParameter(InputStream input) throws IOException {
        return new BigInteger(1, TlsUtils.readOpaque16(input));
    }

    public static void writeDHConfig(TlsDHConfig dhConfig, OutputStream output) throws IOException {
        DHGroup group = TlsDHUtils.getDHGroup(dhConfig);
        TlsDHUtils.writeDHParameter(group.getP(), output);
        TlsDHUtils.writeDHParameter(group.getG(), output);
    }

    public static void writeDHParameter(BigInteger x, OutputStream output) throws IOException {
        TlsUtils.writeOpaque16(BigIntegers.asUnsignedByteArray(x), output);
    }
}

