/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls;

import java.io.IOException;
import java.math.BigInteger;
import shaded.org.bouncycastle.tls.TlsSRPIdentityManager;
import shaded.org.bouncycastle.tls.TlsSRPLoginParameters;
import shaded.org.bouncycastle.tls.crypto.SRP6Group;
import shaded.org.bouncycastle.tls.crypto.TlsCrypto;
import shaded.org.bouncycastle.tls.crypto.TlsHMAC;
import shaded.org.bouncycastle.tls.crypto.TlsMAC;
import shaded.org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import shaded.org.bouncycastle.tls.crypto.TlsSRPConfig;
import shaded.org.bouncycastle.util.Strings;

public class SimulatedTlsSRPIdentityManager
implements TlsSRPIdentityManager {
    private static final byte[] PREFIX_PASSWORD = Strings.toByteArray("password");
    private static final byte[] PREFIX_SALT = Strings.toByteArray("salt");
    protected SRP6Group group;
    protected TlsSRP6VerifierGenerator verifierGenerator;
    protected TlsMAC mac;

    public static SimulatedTlsSRPIdentityManager getRFC5054Default(TlsCrypto crypto, SRP6Group group, byte[] seedKey) throws IOException {
        TlsHMAC mac = crypto.createHMAC(2);
        mac.setKey(seedKey, 0, seedKey.length);
        TlsSRPConfig srpConfig = new TlsSRPConfig();
        srpConfig.setExplicitNG(new BigInteger[]{group.getN(), group.getG()});
        return new SimulatedTlsSRPIdentityManager(group, crypto.createSRP6VerifierGenerator(srpConfig), mac);
    }

    public SimulatedTlsSRPIdentityManager(SRP6Group group, TlsSRP6VerifierGenerator verifierGenerator, TlsMAC mac) {
        this.group = group;
        this.verifierGenerator = verifierGenerator;
        this.mac = mac;
    }

    @Override
    public TlsSRPLoginParameters getLoginParameters(byte[] identity) {
        this.mac.update(PREFIX_SALT, 0, PREFIX_SALT.length);
        this.mac.update(identity, 0, identity.length);
        byte[] salt = this.mac.calculateMAC();
        this.mac.update(PREFIX_PASSWORD, 0, PREFIX_PASSWORD.length);
        this.mac.update(identity, 0, identity.length);
        byte[] password = this.mac.calculateMAC();
        BigInteger verifier = this.verifierGenerator.generateVerifier(salt, identity, password);
        TlsSRPConfig srpConfig = new TlsSRPConfig();
        srpConfig.setExplicitNG(new BigInteger[]{this.group.getN(), this.group.getG()});
        return new TlsSRPLoginParameters(srpConfig, verifier, salt);
    }
}

