/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import shaded.org.bouncycastle.tls.AbstractTlsClient;
import shaded.org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import shaded.org.bouncycastle.tls.DefaultTlsSRPConfigVerifier;
import shaded.org.bouncycastle.tls.TlsAuthentication;
import shaded.org.bouncycastle.tls.TlsExtensionsUtils;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.TlsKeyExchange;
import shaded.org.bouncycastle.tls.TlsKeyExchangeFactory;
import shaded.org.bouncycastle.tls.TlsSRPConfigVerifier;
import shaded.org.bouncycastle.tls.TlsSRPUtils;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.TlsCrypto;
import shaded.org.bouncycastle.util.Arrays;

public class SRPTlsClient
extends AbstractTlsClient {
    public static final int[] BASE_CIPHER_SUITES = new int[]{49182};
    protected TlsSRPConfigVerifier srpConfigVerifier;
    protected byte[] identity;
    protected byte[] password;
    protected int[] supportedCipherSuites;

    public SRPTlsClient(TlsCrypto crypto, byte[] identity, byte[] password) {
        this(crypto, new DefaultTlsKeyExchangeFactory(), new DefaultTlsSRPConfigVerifier(), identity, password);
    }

    public SRPTlsClient(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory, TlsSRPConfigVerifier srpConfigVerifier, byte[] identity, byte[] password) {
        super(crypto, keyExchangeFactory);
        this.srpConfigVerifier = srpConfigVerifier;
        this.identity = Arrays.clone(identity);
        this.password = Arrays.clone(password);
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    protected boolean requireSRPServerExtension() {
        return false;
    }

    @Override
    public int[] getCipherSuites() {
        return Arrays.clone(this.supportedCipherSuites);
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        TlsSRPUtils.addSRPExtension(clientExtensions, this.identity);
        return clientExtensions;
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (!TlsUtils.hasExpectedEmptyExtensionData(serverExtensions, TlsSRPUtils.EXT_SRP, (short)47) && this.requireSRPServerExtension()) {
            throw new TlsFatalAlert(47);
        }
        super.processServerExtensions(serverExtensions);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 21: 
            case 22: 
            case 23: {
                return this.createSRPKeyExchange(keyExchangeAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createSRPKeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.srpConfigVerifier, this.identity, this.password);
    }
}

