/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls;

import java.io.IOException;
import shaded.org.bouncycastle.tls.AbstractTlsServer;
import shaded.org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import shaded.org.bouncycastle.tls.TlsCredentialedDecryptor;
import shaded.org.bouncycastle.tls.TlsCredentials;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.TlsKeyExchange;
import shaded.org.bouncycastle.tls.TlsKeyExchangeFactory;
import shaded.org.bouncycastle.tls.TlsPSKIdentityManager;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.TlsCrypto;
import shaded.org.bouncycastle.tls.crypto.TlsDHConfig;
import shaded.org.bouncycastle.tls.crypto.TlsECConfig;
import shaded.org.bouncycastle.util.Arrays;

public class PSKTlsServer
extends AbstractTlsServer {
    public static final int[] BASE_CIPHER_SUITES = new int[]{52396, 49208, 49207, 49206, 49205, 52397, 171, 170, 179, 178, 145, 144};
    protected TlsPSKIdentityManager pskIdentityManager;
    protected int[] supportedCipherSuites;

    public PSKTlsServer(TlsCrypto crypto, TlsPSKIdentityManager pskIdentityManager) {
        this(crypto, new DefaultTlsKeyExchangeFactory(), pskIdentityManager);
    }

    public PSKTlsServer(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory, TlsPSKIdentityManager pskIdentityManager) {
        super(crypto, keyExchangeFactory);
        this.pskIdentityManager = pskIdentityManager;
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    protected int[] getCipherSuites() {
        return Arrays.clone(this.supportedCipherSuites);
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 13: 
            case 14: 
            case 24: {
                return null;
            }
            case 15: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 14: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, this.selectDHConfig(), null);
            }
            case 24: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, null, this.selectECConfig());
            }
            case 13: 
            case 15: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, null, null);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange, TlsDHConfig dhConfig, TlsECConfig ecConfig) throws IOException {
        return this.keyExchangeFactory.createPSKKeyExchangeServer(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentityManager, dhConfig, ecConfig, this.serverECPointFormats);
    }
}

