/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls;

import shaded.org.bouncycastle.tls.ProtocolVersion;
import shaded.org.bouncycastle.tls.SecurityParameters;
import shaded.org.bouncycastle.tls.TlsContext;
import shaded.org.bouncycastle.tls.TlsSession;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.TlsCrypto;
import shaded.org.bouncycastle.tls.crypto.TlsNonceGenerator;
import shaded.org.bouncycastle.util.Arrays;
import shaded.org.bouncycastle.util.Pack;
import shaded.org.bouncycastle.util.Times;

abstract class AbstractTlsContext
implements TlsContext {
    private static long counter = Times.nanoTime();
    private TlsCrypto crypto;
    private TlsNonceGenerator nonceGenerator;
    private SecurityParameters securityParameters;
    private ProtocolVersion clientVersion = null;
    private ProtocolVersion serverVersion = null;
    private TlsSession session = null;
    private Object userObject = null;

    private static synchronized long nextCounterValue() {
        return ++counter;
    }

    private static TlsNonceGenerator createNonceGenerator(TlsCrypto crypto, SecurityParameters securityParameters) {
        byte[] additionalSeedMaterial = new byte[16];
        Pack.longToBigEndian(AbstractTlsContext.nextCounterValue(), additionalSeedMaterial, 0);
        Pack.longToBigEndian(Times.nanoTime(), additionalSeedMaterial, 8);
        additionalSeedMaterial[0] = (byte)securityParameters.entity;
        return crypto.createNonceGenerator(additionalSeedMaterial);
    }

    AbstractTlsContext(TlsCrypto crypto, SecurityParameters securityParameters) {
        this.crypto = crypto;
        this.nonceGenerator = AbstractTlsContext.createNonceGenerator(crypto, securityParameters);
        this.securityParameters = securityParameters;
    }

    @Override
    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    @Override
    public TlsNonceGenerator getNonceGenerator() {
        return this.nonceGenerator;
    }

    @Override
    public SecurityParameters getSecurityParameters() {
        return this.securityParameters;
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    void setClientVersion(ProtocolVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    @Override
    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    void setServerVersion(ProtocolVersion serverVersion) {
        this.serverVersion = serverVersion;
    }

    @Override
    public TlsSession getResumableSession() {
        TlsSession session = this.getSession();
        if (session == null || !session.isResumable()) {
            return null;
        }
        return session;
    }

    @Override
    public TlsSession getSession() {
        return this.session;
    }

    void setSession(TlsSession session) {
        this.session = session;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public byte[] exportChannelBinding(int channelBinding) {
        switch (channelBinding) {
            case 1: {
                byte[] tlsUnique = this.getSecurityParameters().getTLSUnique();
                if (tlsUnique == null) {
                    throw new IllegalStateException("'tls-unique' channel binding unavailable before handshake completion");
                }
                return Arrays.clone(tlsUnique);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] exportKeyingMaterial(String asciiLabel, byte[] context_value, int length) {
        if (context_value != null && !TlsUtils.isValidUint16(context_value.length)) {
            throw new IllegalArgumentException("'context_value' must have length less than 2^16 (or be null)");
        }
        SecurityParameters sp = this.getSecurityParameters();
        byte[] cr = sp.getClientRandom();
        byte[] sr = sp.getServerRandom();
        int seedLength = cr.length + sr.length;
        if (context_value != null) {
            seedLength += 2 + context_value.length;
        }
        byte[] seed = new byte[seedLength];
        int seedPos = 0;
        System.arraycopy(cr, 0, seed, seedPos, cr.length);
        System.arraycopy(sr, 0, seed, seedPos += cr.length, sr.length);
        seedPos += sr.length;
        if (context_value != null) {
            TlsUtils.writeUint16(context_value.length, seed, seedPos);
            System.arraycopy(context_value, 0, seed, seedPos += 2, context_value.length);
            seedPos += context_value.length;
        }
        if (seedPos != seedLength) {
            throw new IllegalStateException("error in calculation of seed for export");
        }
        return TlsUtils.PRF(this, sp.getMasterSecret(), asciiLabel, seed, length).extract();
    }
}

