/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.pqc.jcajce.provider.ntru;

import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.DecapsulateException;
import javax.crypto.KEMSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import shaded.org.bouncycastle.jcajce.spec.KTSParameterSpec;
import shaded.org.bouncycastle.pqc.crypto.ntru.NTRUKEMExtractor;
import shaded.org.bouncycastle.pqc.jcajce.provider.Util;
import shaded.org.bouncycastle.pqc.jcajce.provider.ntru.BCNTRUPrivateKey;

public class NTRUDecapsulatorSpi
implements KEMSpi.DecapsulatorSpi {
    BCNTRUPrivateKey privateKey;
    KTSParameterSpec parameterSpec;
    NTRUKEMExtractor kemExt;

    public NTRUDecapsulatorSpi(BCNTRUPrivateKey bCNTRUPrivateKey, KTSParameterSpec kTSParameterSpec) {
        this.privateKey = bCNTRUPrivateKey;
        this.parameterSpec = kTSParameterSpec;
        this.kemExt = new NTRUKEMExtractor(bCNTRUPrivateKey.getKeyParams());
    }

    @Override
    public SecretKey engineDecapsulate(byte[] byArray, int n, int n2, String string) throws DecapsulateException {
        Objects.checkFromToIndex(n, n2, this.engineSecretSize());
        Objects.requireNonNull(string, "null algorithm");
        Objects.requireNonNull(byArray, "null encapsulation");
        if (byArray.length != this.engineEncapsulationSize()) {
            throw new DecapsulateException("incorrect encapsulation size");
        }
        if (!this.parameterSpec.getKeyAlgorithmName().equals("Generic") && string.equals("Generic")) {
            string = this.parameterSpec.getKeyAlgorithmName();
        }
        if (!this.parameterSpec.getKeyAlgorithmName().equals("Generic") && !this.parameterSpec.getKeyAlgorithmName().equals(string)) {
            throw new UnsupportedOperationException(this.parameterSpec.getKeyAlgorithmName() + " does not match " + string);
        }
        boolean bl = this.parameterSpec.getKdfAlgorithm() != null;
        byte[] byArray2 = this.kemExt.extractSecret(byArray);
        if (bl) {
            try {
                byArray2 = Util.makeKeyBytes((KTSParameterSpec)this.parameterSpec, (byte[])byArray2);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IllegalStateException(invalidKeyException);
            }
        }
        byte[] byArray3 = Arrays.copyOfRange(byArray2, n, n2);
        return new SecretKeySpec(byArray3, string);
    }

    @Override
    public int engineSecretSize() {
        return this.parameterSpec.getKeySize() / 8;
    }

    @Override
    public int engineEncapsulationSize() {
        return this.kemExt.getEncapsulationLength();
    }
}

