/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.pqc.jcajce.provider.mceliece;

import java.io.IOException;
import java.security.PublicKey;
import shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shaded.org.bouncycastle.crypto.CipherParameters;
import shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shaded.org.bouncycastle.pqc.asn1.McElieceCCA2PublicKey;
import shaded.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import shaded.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import shaded.org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import shaded.org.bouncycastle.pqc.jcajce.provider.mceliece.Utils;
import shaded.org.bouncycastle.pqc.math.linearalgebra.GF2Matrix;

public class BCMcElieceCCA2PublicKey
implements CipherParameters,
PublicKey {
    private static final long serialVersionUID = 1L;
    private McElieceCCA2PublicKeyParameters params;

    public BCMcElieceCCA2PublicKey(McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters) {
        this.params = mcElieceCCA2PublicKeyParameters;
    }

    @Override
    public String getAlgorithm() {
        return "McEliece-CCA2";
    }

    public int getN() {
        return ((McElieceCCA2PublicKeyParameters)((Object)this.params)).getN();
    }

    public int getK() {
        return ((McElieceCCA2PublicKeyParameters)((Object)this.params)).getK();
    }

    public int getT() {
        return ((McElieceCCA2PublicKeyParameters)((Object)this.params)).getT();
    }

    public GF2Matrix getG() {
        return ((McElieceCCA2PublicKeyParameters)((Object)this.params)).getG();
    }

    public String toString() {
        Object object = "McEliecePublicKey:\n";
        object = (String)object + " length of the code         : " + ((McElieceCCA2PublicKeyParameters)((Object)this.params)).getN() + "\n";
        object = (String)object + " error correction capability: " + ((McElieceCCA2PublicKeyParameters)((Object)this.params)).getT() + "\n";
        object = (String)object + " generator matrix           : " + ((McElieceCCA2PublicKeyParameters)((Object)this.params)).getG().toString();
        return object;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BCMcElieceCCA2PublicKey)) {
            return false;
        }
        BCMcElieceCCA2PublicKey bCMcElieceCCA2PublicKey = (BCMcElieceCCA2PublicKey)object;
        return ((McElieceCCA2PublicKeyParameters)((Object)this.params)).getN() == bCMcElieceCCA2PublicKey.getN() && ((McElieceCCA2PublicKeyParameters)((Object)this.params)).getT() == bCMcElieceCCA2PublicKey.getT() && ((McElieceCCA2PublicKeyParameters)((Object)this.params)).getG().equals(bCMcElieceCCA2PublicKey.getG());
    }

    public int hashCode() {
        return 37 * (((McElieceCCA2PublicKeyParameters)((Object)this.params)).getN() + 37 * ((McElieceCCA2PublicKeyParameters)((Object)this.params)).getT()) + ((McElieceCCA2PublicKeyParameters)((Object)this.params)).getG().hashCode();
    }

    @Override
    public byte[] getEncoded() {
        McElieceCCA2PublicKey mcElieceCCA2PublicKey = new McElieceCCA2PublicKey(((McElieceCCA2PublicKeyParameters)((Object)this.params)).getN(), ((McElieceCCA2PublicKeyParameters)((Object)this.params)).getT(), ((McElieceCCA2PublicKeyParameters)((Object)this.params)).getG(), Utils.getDigAlgId((String)((McElieceCCA2KeyParameters)((Object)this.params)).getDigest()));
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcElieceCca2);
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, mcElieceCCA2PublicKey);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    AsymmetricKeyParameter getKeyParams() {
        return this.params;
    }
}

