/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.pqc.crypto.picnic;

import java.security.SecureRandom;
import shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import shaded.org.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import shaded.org.bouncycastle.pqc.crypto.picnic.PicnicKeyGenerationParameters;
import shaded.org.bouncycastle.pqc.crypto.picnic.PicnicParameters;
import shaded.org.bouncycastle.pqc.crypto.picnic.PicnicPrivateKeyParameters;
import shaded.org.bouncycastle.pqc.crypto.picnic.PicnicPublicKeyParameters;

public class PicnicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private PicnicParameters parameters;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        this.parameters = ((PicnicKeyGenerationParameters)keyGenerationParameters).getParameters();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        PicnicEngine picnicEngine = this.parameters.getEngine();
        byte[] byArray = new byte[picnicEngine.getSecretKeySize()];
        byte[] byArray2 = new byte[picnicEngine.getPublicKeySize()];
        picnicEngine.crypto_sign_keypair(byArray2, byArray, this.random);
        PicnicPublicKeyParameters picnicPublicKeyParameters = new PicnicPublicKeyParameters(this.parameters, byArray2);
        PicnicPrivateKeyParameters picnicPrivateKeyParameters = new PicnicPrivateKeyParameters(this.parameters, byArray);
        return new AsymmetricCipherKeyPair(picnicPublicKeyParameters, picnicPrivateKeyParameters);
    }
}

