/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.pkcs.bc;

import shaded.org.bouncycastle.asn1.DERNull;
import shaded.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.org.bouncycastle.operator.MacCalculator;
import shaded.org.bouncycastle.operator.OperatorCreationException;
import shaded.org.bouncycastle.operator.bc.BcDigestProvider;
import shaded.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import shaded.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import shaded.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private BcDigestProvider digestProvider;

    public BcPKCS12MacCalculatorBuilderProvider(BcDigestProvider bcDigestProvider) {
        this.digestProvider = bcDigestProvider;
    }

    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            public MacCalculator build(char[] cArray) throws OperatorCreationException {
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(algorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProvider.this.digestProvider.get(algorithmIdentifier), pKCS12PBEParams, cArray);
            }

            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

