/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jsse.provider.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import shaded.org.bouncycastle.util.Strings;

class TestProtocolUtil {
    TestProtocolUtil() {
    }

    public static void runClientAndServer(BlockingCallable server, BlockingCallable client) throws InterruptedException {
        Task serverTask = new Task(server);
        Thread serverThread = new Thread(serverTask);
        serverThread.start();
        server.await();
        Task clientTask = new Task(client);
        Thread clientThread = new Thread(clientTask);
        clientThread.start();
        client.await();
        serverThread.join();
        clientThread.join();
        Assert.assertNull((Object)serverTask.getResult());
        Assert.assertNull((Object)clientTask.getResult());
    }

    public static void doClientProtocol(Socket sock, String text) throws IOException {
        OutputStream out = sock.getOutputStream();
        InputStream in = sock.getInputStream();
        TestProtocolUtil.writeMessage(text, out);
        String message = TestProtocolUtil.readMessage(in);
        Assert.assertEquals((String)"World", (String)message);
    }

    public static void doServerProtocol(Socket sock, String text) throws IOException {
        OutputStream out = sock.getOutputStream();
        InputStream in = sock.getInputStream();
        String message = TestProtocolUtil.readMessage(in);
        TestProtocolUtil.writeMessage(text, out);
        Assert.assertEquals((String)"Hello", (String)message);
    }

    private static void writeMessage(String text, OutputStream out) throws IOException {
        out.write(Strings.toByteArray(text));
        out.write(33);
    }

    private static String readMessage(InputStream in) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = in.read()) != 33) {
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public static class Task
    implements Runnable {
        private final Callable<Exception> callable;
        private Exception result = null;

        public Task(Callable<Exception> callable) {
            this.callable = callable;
        }

        public Exception getResult() {
            return this.result;
        }

        @Override
        public void run() {
            try {
                this.result = this.callable.call();
            }
            catch (Exception e) {
                this.result = e;
            }
        }
    }

    public static interface BlockingCallable
    extends Callable<Exception> {
        public void await() throws InterruptedException;
    }
}

