/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jsse.provider.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.concurrent.CountDownLatch;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import junit.framework.TestCase;
import shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import shaded.org.bouncycastle.jsse.provider.test.SSLUtils;
import shaded.org.bouncycastle.jsse.provider.test.TestProtocolUtil;
import shaded.org.bouncycastle.jsse.provider.test.TestUtils;

public class BasicGMTlsTest
extends TestCase {
    private static final String HOST = "localhost";
    private static final int PORT_NO = 9021;

    protected void setUp() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        if (Security.getProvider("BCJSSE") == null) {
            Security.addProvider(new BouncyCastleJsseProvider("BC"));
        }
    }

    public void testLocaleServer() throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        Certificate rootCertificate1 = certificateFactory.generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode("MIIB4TCCAYagAwIBAgIGAJWY30yAMAwGCCqBHM9VAYN1BQAwRTELMAkGA1UEBhMCY24xIzAhBgNVBAoMGklORk9TRUMgVGVjaG5vbG9naWVzIFNNMklEMREwDwYDVQQDDAhhcHBTTTJJRDAeFw0xNjA0MjAwMjQ3MTZaFw0yNjA0MjAwMjQ3MTZaMEUxCzAJBgNVBAYTAmNuMSMwIQYDVQQKDBpJTkZPU0VDIFRlY2hub2xvZ2llcyBTTTJJRDERMA8GA1UEAwwIYXBwU00ySUQwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAASu6YQVj5+fJm70mbj8I/gwUm8Q4n465pNEk/o6kDQPdYFbZa7XsZxD8eeJbPdLihyVG6ObVL5ekwoGIT/acMSZo2AwXjAfBgNVHSMEGDAWgBSGtvyPwX8eRKtSZoYOCp8hpE9nUzAPBgNVHRMBAf8EBTADAQH/MAsGA1UdDwQEAwIBBjAdBgNVHQ4EFgQUhrb8j8F/HkSrUmaGDgqfIaRPZ1MwDAYIKoEcz1UBg3UFAANHADBEAiAjGiAduxgd3jursCHShLCMb8Lixxzolt+3kiAZCoJoKwIgY2b+HOjQZKzm9GrVtsBcrm/WSXUxAEzrBh/kmaA9hbQ=")));
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null, null);
        trustStore.setCertificateEntry("ca1", rootCertificate1);
        TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
        trustMgrFact.init(trustStore);
        SSLContext clientContext = SSLContext.getInstance("GMTLSV1.1", "BCJSSE");
        clientContext.init(null, trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BC"));
        SSLSocketFactory fact = clientContext.getSocketFactory();
        SSLSocket cSock = (SSLSocket)fact.createSocket("127.0.0.1", 10444);
        OutputStream outputStream = cSock.getOutputStream();
        outputStream.write("GET /index.html HTTP/1.1\r\nUser-Agent: curl/7.40.0\r\nConnection: keep-alive\r\nHost: www.baidu.com\r\n\r\n".getBytes());
        InputStream inputStream = cSock.getInputStream();
        byte[] readDataBuf = new byte[1024];
        int readLen = inputStream.read(readDataBuf);
        System.out.println("readLen: " + readLen);
        String responseString = new String(readDataBuf);
        System.out.println("return: " + responseString);
    }

    public void testRemoteServer() throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        Certificate rootCertificate1 = certificateFactory.generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode("MIICFDCCAbegAwIBAgIKPYozwkCO86Nd9TAMBggqgRzPVQGDdQUAMF0xCzAJBgNVBAYTAkNOMTAwLgYDVQQKDCdDaGluYSBGaW5hbmNpYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxHDAaBgNVBAMME0NGQ0EgVEVTVCBDUyBTTTIgQ0EwHhcNMTIwODI5MDMyOTQ2WhcNMzIwODI5MDMyOTQ2WjBdMQswCQYDVQQGEwJDTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRwwGgYDVQQDDBNDRkNBIFRFU1QgQ1MgU00yIENBMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEtTjB3O4JueYFDDOtxH678HBZbEmrsgd3BDIdGf0BekyA26n9S0/pKPnjBh/zLouS8+GB5EEnjbn4An24yo1Gv6NdMFswHwYDVR0jBBgwFoAUtdiQb1zw2DPSY71+ssONxk8SemEwDAYDVR0TBAUwAwEB/zALBgNVHQ8EBAMCAQYwHQYDVR0OBBYEFLXYkG9c8Ngz0mO9frLDjcZPEnphMAwGCCqBHM9VAYN1BQADSQAwRgIhAKwuuqoBS1bwDowWa4IU//UsvudswJYSlltqrd/PQ9q+AiEAyTUAjFdaGI+8yPdr3A93UiA38wtGPf9e6B6O/6abyWE=")));
        Certificate rootCertificate2 = certificateFactory.generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode("MIICTTCCAfKgAwIBAgIKZCTXgL0MKPOtBzAMBggqgRzPVQGDdQUAMF0xCzAJBgNVBAYTAkNOMTAwLgYDVQQKDCdDaGluYSBGaW5hbmNpYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxHDAaBgNVBAMME0NGQ0EgVEVTVCBDUyBTTTIgQ0EwHhcNMTIxMjI1MTIyNTA2WhcNMzIwNzIzMTIyNTA2WjBcMQswCQYDVQQGEwJDTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRswGQYDVQQDDBJDRkNBIFRFU1QgU00yIE9DQTEwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAAQzuFgJbedY55u6NToJElGWzPT+9UF1dxcopnerNO3fqRd4C1lDzz9LJZSfmMyNYakyYC+6zh9G6/aPXW1Od/RFo4GYMIGVMB8GA1UdIwQYMBaAFLXYkG9c8Ngz0mO9frLDjcZPEnphMAwGA1UdEwQFMAMBAf8wOAYDVR0fBDEwLzAtoCugKYYnaHR0cDovLzIxMC43NC40Mi4zL3Rlc3RyY2EvU00yL2NybDEuY3JsMAsGA1UdDwQEAwIBBjAdBgNVHQ4EFgQUa/4Y2o9COqa4bbMuiIM6NKLBMOEwDAYIKoEcz1UBg3UFAANHADBEAiARkDmkQ0Clio48994IUs63nA8k652O2C4+7EQs1SSbuAIgcwNUrHJyEYX8xT5BKl9TlJOefzCNNJW5Z0f3Y/SjaG0=")));
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null, null);
        trustStore.setCertificateEntry("ca1", rootCertificate1);
        trustStore.setCertificateEntry("ca2", rootCertificate2);
        TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
        trustMgrFact.init(trustStore);
        SSLContext clientContext = SSLContext.getInstance("GMTLSV1.1", "BCJSSE");
        clientContext.init(null, trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BC"));
        SSLSocketFactory fact = clientContext.getSocketFactory();
        SSLSocket cSock = (SSLSocket)fact.createSocket("10.100.83.104", 38443);
        OutputStream outputStream = cSock.getOutputStream();
        outputStream.write("GET /index.html HTTP/1.1\r\nUser-Agent: curl/7.40.0\r\nConnection: keep-alive\r\nHost: www.baidu.com\r\n\r\n".getBytes());
        InputStream inputStream = cSock.getInputStream();
        byte[] readDataBuf = new byte[1024];
        int readLen = inputStream.read(readDataBuf);
        System.out.println("readLen: " + readLen);
        String responseString = new String(readDataBuf);
        System.out.println("return: " + responseString);
    }

    public void testBasicTlsConnection() throws Exception {
        this.runTestBasicTlsConnection(false);
    }

    public void testBasicTlsConnectionLayered() throws Exception {
        this.runTestBasicTlsConnection(true);
    }

    public void testNullRandomJsseInit() throws Exception {
        char[] keyPass = "keyPassword".toCharArray();
        KeyPair caKeyPair = TestUtils.generateECKeyPair();
        X509Certificate caCert = TestUtils.generateRootCert(caKeyPair);
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setKeyEntry("server", caKeyPair.getPrivate(), keyPass, new X509Certificate[]{caCert});
        KeyStore ts = KeyStore.getInstance("JKS");
        ts.load(null, null);
        ts.setCertificateEntry("ca", caCert);
        TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
        trustMgrFact.init(ts);
        SSLContext clientContext = SSLContext.getInstance("TLS", "BCJSSE");
        clientContext.init(null, trustMgrFact.getTrustManagers(), null);
    }

    protected void runTestBasicTlsConnection(boolean layered) throws Exception {
        char[] keyPass = "keyPassword".toCharArray();
        KeyPair caKeyPair = TestUtils.generateGMKeyPair();
        X509Certificate caCert = TestUtils.generateGMRootCert(caKeyPair);
        KeyPair signKeyPair = TestUtils.generateGMKeyPair();
        X509Certificate signCert = TestUtils.generateGMEndEntityCertSign(signKeyPair.getPublic(), caKeyPair.getPrivate(), caCert);
        KeyPair encKeyPair = TestUtils.generateGMKeyPair();
        X509Certificate encCert = TestUtils.generateGMEndEntityCertEnc(encKeyPair.getPublic(), caKeyPair.getPrivate(), caCert);
        KeyStore signKs = KeyStore.getInstance("BKS", new BouncyCastleProvider());
        signKs.load(null, null);
        signKs.setKeyEntry("server-sign", signKeyPair.getPrivate(), keyPass, new Certificate[]{signCert});
        KeyStore encKs = KeyStore.getInstance("BKS", new BouncyCastleProvider());
        encKs.load(null, null);
        encKs.setKeyEntry("server-enc", encKeyPair.getPrivate(), keyPass, new Certificate[]{encCert});
        KeyStore ts = KeyStore.getInstance("BKS", new BouncyCastleProvider());
        ts.load(null, null);
        ts.setCertificateEntry("ca", caCert);
        TestProtocolUtil.runClientAndServer(new SimpleServer(ts, signKs, encKs, keyPass), new SimpleClient(layered, ts, signKs, encKs, keyPass));
    }

    public static class SimpleServer
    implements TestProtocolUtil.BlockingCallable {
        private final KeyStore trustStore;
        private final KeyStore signStore;
        private final KeyStore encStore;
        private final char[] keyPass;
        private final CountDownLatch latch;

        SimpleServer(KeyStore trustStore, KeyStore serverStore, KeyStore encStore, char[] keyPass) {
            this.trustStore = trustStore;
            this.signStore = serverStore;
            this.encStore = encStore;
            this.keyPass = keyPass;
            this.latch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Exception call() throws Exception {
            try {
                TrustManagerFactory trustMgrFact = null;
                if (null != this.trustStore) {
                    trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
                    trustMgrFact.init(this.trustStore);
                }
                KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
                keyMgrFact.init(this.signStore, this.keyPass);
                keyMgrFact.init(this.encStore, this.keyPass);
                SSLContext serverContext = SSLContext.getInstance("GMTLSV1.1", "BCJSSE");
                serverContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BC"));
                SSLServerSocketFactory fact = serverContext.getServerSocketFactory();
                SSLServerSocket sSock = (SSLServerSocket)fact.createServerSocket(9021);
                SSLUtils.enableAll(sSock);
                this.latch.countDown();
                SSLSocket sslSock = (SSLSocket)sSock.accept();
                sslSock.setUseClientMode(false);
                TestProtocolUtil.doServerProtocol(sslSock, "World");
                sslSock.close();
                sSock.close();
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        @Override
        public void await() throws InterruptedException {
            this.latch.await();
        }
    }

    public static class SimpleClient
    implements TestProtocolUtil.BlockingCallable {
        private final boolean layered;
        private final KeyStore trustStore;
        private final KeyStore signStore;
        private final KeyStore encStore;
        private final char[] keyPass;
        private final CountDownLatch latch;

        public SimpleClient(boolean layered, KeyStore trustStore, KeyStore signStore, KeyStore encStore, char[] keyPass) {
            this.layered = layered;
            this.trustStore = trustStore;
            this.signStore = signStore;
            this.encStore = encStore;
            this.keyPass = keyPass;
            this.latch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Exception call() throws Exception {
            try {
                SSLSocket cSock;
                TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
                trustMgrFact.init(this.trustStore);
                KeyManagerFactory keyMgrFact = null;
                if (null != this.signStore) {
                    keyMgrFact = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
                    keyMgrFact.init(this.signStore, this.keyPass);
                    if (null != this.encStore) {
                        keyMgrFact.init(this.encStore, this.keyPass);
                    }
                }
                SSLContext clientContext = SSLContext.getInstance("GMTLSV1.1", "BCJSSE");
                clientContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BC"));
                SSLSocketFactory fact = clientContext.getSocketFactory();
                if (this.layered) {
                    Socket s = SocketFactory.getDefault().createSocket(BasicGMTlsTest.HOST, 9021);
                    cSock = (SSLSocket)fact.createSocket(s, BasicGMTlsTest.HOST, 9021, true);
                } else {
                    cSock = (SSLSocket)fact.createSocket(BasicGMTlsTest.HOST, 9021);
                }
                TestProtocolUtil.doClientProtocol(cSock, "Hello");
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        @Override
        public void await() throws InterruptedException {
            this.latch.await();
        }
    }
}

