/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jsse.provider;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.X509Certificate;
import shaded.org.bouncycastle.jsse.BCSNIServerName;
import shaded.org.bouncycastle.jsse.provider.JsseUtils;
import shaded.org.bouncycastle.jsse.provider.ProvSSLSession;
import shaded.org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import shaded.org.bouncycastle.jsse.provider.SessionBindingListenerAdapter;
import shaded.org.bouncycastle.tls.SessionParameters;
import shaded.org.bouncycastle.tls.TlsSession;
import shaded.org.bouncycastle.util.Arrays;

class ProvSSLSessionImpl
implements ProvSSLSession {
    static final Constructor<? extends SSLSession> extendedSessionConstructor;
    protected static final ProvSSLSessionImpl NULL_SESSION;
    protected final Map<String, Object> valueMap = Collections.synchronizedMap(new HashMap());
    protected final ProvSSLSessionContext sslSessionContext;
    protected final TlsSession tlsSession;
    protected final String peerHost;
    protected final int peerPort;
    protected final SessionParameters sessionParameters;
    protected final SSLSession exportSession;
    protected final long creationTime;
    protected long lastAccessedTime;

    static SSLSession makeExportSession(ProvSSLSession sslSession) {
        if (extendedSessionConstructor != null) {
            try {
                return extendedSessionConstructor.newInstance(sslSession);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sslSession;
    }

    ProvSSLSessionImpl(ProvSSLSessionContext sslSessionContext, TlsSession tlsSession, String peerHost, int peerPort) {
        this.sslSessionContext = sslSessionContext;
        this.tlsSession = tlsSession;
        this.peerHost = peerHost;
        this.peerPort = peerPort;
        this.sessionParameters = tlsSession == null ? null : tlsSession.exportSessionParameters();
        this.exportSession = ProvSSLSessionImpl.makeExportSession(this);
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
    }

    SSLSession getExportSession() {
        return this.exportSession;
    }

    TlsSession getTlsSession() {
        return this.tlsSession;
    }

    synchronized void accessedAt(long accessTime) {
        this.lastAccessedTime = Math.max(this.lastAccessedTime, accessTime);
    }

    @Override
    public int getApplicationBufferSize() {
        return 16384;
    }

    @Override
    public String getCipherSuite() {
        return this.sessionParameters == null ? null : this.sslSessionContext.getSSLContext().getCipherSuiteString(this.sessionParameters.getCipherSuite());
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public byte[] getId() {
        return this.tlsSession == null ? null : Arrays.clone(this.tlsSession.getSessionID());
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public Certificate[] getLocalCertificates() {
        Certificate[] chain;
        if (this.sessionParameters != null && (chain = JsseUtils.getX509CertificateChain(this.sslSessionContext.getCrypto(), this.sessionParameters.getLocalCertificate())) != null && chain.length > 0) {
            return chain;
        }
        return null;
    }

    @Override
    public Principal getLocalPrincipal() {
        return this.sessionParameters == null ? null : JsseUtils.getSubject(this.sslSessionContext.getCrypto(), this.sessionParameters.getLocalCertificate());
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPacketBufferSize() {
        return 20491;
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        Certificate[] peerCertificates = this.getPeerCertificates();
        try {
            X509Certificate[] chain = new X509Certificate[peerCertificates.length];
            for (int i = 0; i < peerCertificates.length; ++i) {
                chain[i] = X509Certificate.getInstance(peerCertificates[i].getEncoded());
            }
            return chain;
        }
        catch (Exception e) {
            throw new SSLPeerUnverifiedException(e.getMessage());
        }
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        Certificate[] chain;
        if (this.sessionParameters != null && (chain = JsseUtils.getX509CertificateChain(this.sslSessionContext.getCrypto(), this.sessionParameters.getPeerCertificate())) != null && chain.length > 0) {
            return chain;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    @Override
    public String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        X500Principal principal;
        if (this.sessionParameters != null && (principal = JsseUtils.getSubject(this.sslSessionContext.getCrypto(), this.sessionParameters.getPeerCertificate())) != null) {
            return principal;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getProtocol() {
        return this.sessionParameters == null ? null : this.sslSessionContext.getSSLContext().getProtocolString(this.sessionParameters.getNegotiatedVersion());
    }

    @Override
    public List<BCSNIServerName> getRequestedServerNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return this.sslSessionContext;
    }

    @Override
    public Object getValue(String name) {
        return this.valueMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getValueNames() {
        Map<String, Object> map = this.valueMap;
        synchronized (map) {
            return this.valueMap.keySet().toArray(new String[this.valueMap.size()]);
        }
    }

    @Override
    public void invalidate() {
        if (this.tlsSession != null) {
            this.tlsSession.invalidate();
        }
    }

    @Override
    public boolean isValid() {
        return this.tlsSession != null && this.tlsSession.isResumable();
    }

    @Override
    public void putValue(String name, Object value) {
        this.notifyUnbound(name, this.valueMap.put(name, value));
        this.notifyBound(name, value);
    }

    @Override
    public void removeValue(String name) {
        this.notifyUnbound(name, this.valueMap.remove(name));
    }

    protected void notifyBound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            new SessionBindingListenerAdapter((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
    }

    protected void notifyUnbound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            new SessionBindingListenerAdapter((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    static {
        Constructor cons = null;
        try {
            if (null != JsseUtils.loadClass(ProvSSLSessionImpl.class, "javax.net.ssl.ExtendedSSLSession")) {
                String className = null != JsseUtils.loadClass(ProvSSLSessionImpl.class, "javax.net.ssl.SNIHostName") ? "shaded.org.bouncycastle.jsse.provider.ProvExtendedSSLSession_8" : "shaded.org.bouncycastle.jsse.provider.ProvExtendedSSLSession_7";
                Class clazz = JsseUtils.loadClass(ProvSSLSessionContext.class, className);
                cons = JsseUtils.getDeclaredConstructor(clazz, ProvSSLSession.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        extendedSessionConstructor = cons;
        NULL_SESSION = new ProvSSLSessionImpl(null, null, null, -1);
    }
}

