/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jsse.provider;

import shaded.org.bouncycastle.jsse.provider.PropertyUtils;
import shaded.org.bouncycastle.tls.DefaultTlsDHConfigVerifier;
import shaded.org.bouncycastle.tls.crypto.TlsDHConfig;

class ProvDHConfigVerifier
extends DefaultTlsDHConfigVerifier {
    private static final int provMinimumPrimeBits = PropertyUtils.getIntegerSystemProperty("shaded.org.bouncycastle.jsse.client.dh.minimumPrimeBits", 2048, 1024, 16384);
    private static final boolean provUnrestrictedGroups = PropertyUtils.getBooleanSystemProperty("shaded.org.bouncycastle.jsse.client.dh.unrestrictedGroups", false);

    ProvDHConfigVerifier() {
        super(provMinimumPrimeBits);
    }

    @Override
    protected boolean checkGroup(TlsDHConfig dhConfig) {
        return provUnrestrictedGroups || super.checkGroup(dhConfig);
    }
}

