/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jcajce.provider.asymmetric;

import java.util.HashMap;
import java.util.Map;
import shaded.org.bouncycastle.internal.asn1.edec.EdECObjectIdentifiers;
import shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi;
import shaded.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import shaded.org.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;

public class EdEC {
    private static final String PREFIX = "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.";
    private static final Map<String, String> edxAttributes = new HashMap<String, String>();

    static {
        edxAttributes.put("SupportedKeyClasses", "java.security.interfaces.ECPublicKey|java.security.interfaces.ECPrivateKey");
        edxAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("KeyFactory.XDH", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$XDH");
            configurableProvider.addAlgorithm("KeyFactory.X448", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$X448");
            configurableProvider.addAlgorithm("KeyFactory.X25519", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$X25519");
            configurableProvider.addAlgorithm("KeyFactory.EDDSA", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$EdDSA");
            configurableProvider.addAlgorithm("KeyFactory.ED448", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$Ed448");
            configurableProvider.addAlgorithm("KeyFactory.ED25519", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi$Ed25519");
            configurableProvider.addAlgorithm("Signature.EDDSA", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.SignatureSpi$EdDSA");
            configurableProvider.addAlgorithm("Signature.ED448", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.SignatureSpi$Ed448");
            configurableProvider.addAlgorithm("Signature.ED25519", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.SignatureSpi$Ed25519");
            configurableProvider.addAlgorithm("Alg.Alias.Signature", EdECObjectIdentifiers.id_Ed448, "ED448");
            configurableProvider.addAlgorithm("Alg.Alias.Signature", EdECObjectIdentifiers.id_Ed25519, "ED25519");
            configurableProvider.addAlgorithm("KeyPairGenerator.EDDSA", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$EdDSA");
            configurableProvider.addAlgorithm("KeyPairGenerator.ED448", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$Ed448");
            configurableProvider.addAlgorithm("KeyPairGenerator.ED25519", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$Ed25519");
            configurableProvider.addAlgorithm("KeyPairGenerator", EdECObjectIdentifiers.id_Ed448, "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$Ed448");
            configurableProvider.addAlgorithm("KeyPairGenerator", EdECObjectIdentifiers.id_Ed25519, "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$Ed25519");
            configurableProvider.addAlgorithm("KeyAgreement.XDH", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$XDH");
            configurableProvider.addAlgorithm("KeyAgreement.X448", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X448");
            configurableProvider.addAlgorithm("KeyAgreement.X25519", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X25519");
            configurableProvider.addAlgorithm("KeyAgreement", EdECObjectIdentifiers.id_X448, "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X448");
            configurableProvider.addAlgorithm("KeyAgreement", EdECObjectIdentifiers.id_X25519, "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X25519");
            configurableProvider.addAlgorithm("KeyAgreement.X25519WITHSHA256CKDF", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X25519withSHA256CKDF");
            configurableProvider.addAlgorithm("KeyAgreement.X25519WITHSHA384CKDF", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X25519withSHA384CKDF");
            configurableProvider.addAlgorithm("KeyAgreement.X25519WITHSHA512CKDF", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X25519withSHA512CKDF");
            configurableProvider.addAlgorithm("KeyAgreement.X448WITHSHA256CKDF", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X448withSHA256CKDF");
            configurableProvider.addAlgorithm("KeyAgreement.X448WITHSHA384CKDF", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X448withSHA384CKDF");
            configurableProvider.addAlgorithm("KeyAgreement.X448WITHSHA512CKDF", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X448withSHA512CKDF");
            configurableProvider.addAlgorithm("KeyAgreement.X25519WITHSHA256KDF", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X25519withSHA256KDF");
            configurableProvider.addAlgorithm("KeyAgreement.X448WITHSHA512KDF", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X448withSHA512KDF");
            configurableProvider.addAlgorithm("KeyAgreement.X25519UWITHSHA256KDF", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X25519UwithSHA256KDF");
            configurableProvider.addAlgorithm("KeyAgreement.X448UWITHSHA512KDF", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X448UwithSHA512KDF");
            configurableProvider.addAlgorithm("KeyAgreement.X448withSHA512HKDF", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X448withSHA512HKDF");
            configurableProvider.addAlgorithm("KeyAgreement.X25519withSHA256HKDF", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyAgreementSpi$X25519withSHA256HKDF");
            configurableProvider.addAlgorithm("KeyPairGenerator.XDH", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$XDH");
            configurableProvider.addAlgorithm("KeyPairGenerator.X448", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$X448");
            configurableProvider.addAlgorithm("KeyPairGenerator.X25519", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$X25519");
            configurableProvider.addAlgorithm("KeyPairGenerator", EdECObjectIdentifiers.id_X448, "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$X448");
            configurableProvider.addAlgorithm("KeyPairGenerator", EdECObjectIdentifiers.id_X25519, "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyPairGeneratorSpi$X25519");
            configurableProvider.addAlgorithm("Cipher.XIES", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIES");
            configurableProvider.addAlgorithm("Cipher.XIESwithSHA1", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIES");
            configurableProvider.addAlgorithm("Cipher.XIESWITHSHA1", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIES");
            configurableProvider.addAlgorithm("Cipher.XIESwithSHA256", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithSHA256");
            configurableProvider.addAlgorithm("Cipher.XIESWITHSHA256", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithSHA256");
            configurableProvider.addAlgorithm("Cipher.XIESwithSHA384", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithSHA384");
            configurableProvider.addAlgorithm("Cipher.XIESWITHSHA384", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithSHA384");
            configurableProvider.addAlgorithm("Cipher.XIESwithSHA512", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithSHA512");
            configurableProvider.addAlgorithm("Cipher.XIESWITHSHA512", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithSHA512");
            configurableProvider.addAlgorithm("Cipher.XIESwithAES-CBC", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithAESCBC");
            configurableProvider.addAlgorithm("Cipher.XIESWITHAES-CBC", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithAESCBC");
            configurableProvider.addAlgorithm("Cipher.XIESwithSHA1andAES-CBC", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithAESCBC");
            configurableProvider.addAlgorithm("Cipher.XIESWITHSHA1ANDAES-CBC", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithAESCBC");
            configurableProvider.addAlgorithm("Cipher.XIESwithSHA256andAES-CBC", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithSHA256andAESCBC");
            configurableProvider.addAlgorithm("Cipher.XIESWITHSHA256ANDAES-CBC", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithSHA256andAESCBC");
            configurableProvider.addAlgorithm("Cipher.XIESwithSHA384andAES-CBC", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithSHA384andAESCBC");
            configurableProvider.addAlgorithm("Cipher.XIESWITHSHA384ANDAES-CBC", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithSHA384andAESCBC");
            configurableProvider.addAlgorithm("Cipher.XIESwithSHA512andAES-CBC", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithSHA512andAESCBC");
            configurableProvider.addAlgorithm("Cipher.XIESWITHSHA512ANDAES-CBC", "shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.IESCipher$XIESwithSHA512andAESCBC");
            this.registerOid(configurableProvider, EdECObjectIdentifiers.id_X448, "XDH", new KeyFactorySpi.X448());
            this.registerOid(configurableProvider, EdECObjectIdentifiers.id_X25519, "XDH", new KeyFactorySpi.X25519());
            this.registerOid(configurableProvider, EdECObjectIdentifiers.id_Ed448, "EDDSA", new KeyFactorySpi.Ed448());
            this.registerOid(configurableProvider, EdECObjectIdentifiers.id_Ed25519, "EDDSA", new KeyFactorySpi.Ed25519());
        }
    }
}

