/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.cms;

import java.io.IOException;
import shaded.org.bouncycastle.asn1.cms.KEKIdentifier;
import shaded.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.org.bouncycastle.cms.AuthAttributesProvider;
import shaded.org.bouncycastle.cms.CMSException;
import shaded.org.bouncycastle.cms.CMSSecureReadable;
import shaded.org.bouncycastle.cms.KEKRecipient;
import shaded.org.bouncycastle.cms.KEKRecipientId;
import shaded.org.bouncycastle.cms.Recipient;
import shaded.org.bouncycastle.cms.RecipientInformation;
import shaded.org.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

