/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.cms;

import shaded.org.bouncycastle.asn1.ASN1OctetString;
import shaded.org.bouncycastle.asn1.DEROctetString;
import shaded.org.bouncycastle.asn1.cms.KEKIdentifier;
import shaded.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import shaded.org.bouncycastle.asn1.cms.RecipientInfo;
import shaded.org.bouncycastle.cms.CMSException;
import shaded.org.bouncycastle.cms.RecipientInfoGenerator;
import shaded.org.bouncycastle.operator.GenericKey;
import shaded.org.bouncycastle.operator.OperatorException;
import shaded.org.bouncycastle.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kEKIdentifier, SymmetricKeyWrapper symmetricKeyWrapper) {
        this.kekIdentifier = kEKIdentifier;
        this.wrapper = symmetricKeyWrapper;
    }

    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        try {
            DEROctetString dEROctetString = new DEROctetString(this.wrapper.generateWrappedKey(genericKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), (ASN1OctetString)dEROctetString));
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
    }
}

