/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import shaded.org.bouncycastle.cms.CMSException;
import shaded.org.bouncycastle.cms.CMSProcessable;
import shaded.org.bouncycastle.cms.CMSReadable;
import shaded.org.bouncycastle.util.io.Streams;

class CMSProcessableInputStream
implements CMSProcessable,
CMSReadable {
    private InputStream input;
    private boolean used = false;

    public CMSProcessableInputStream(InputStream inputStream) {
        this.input = inputStream;
    }

    public InputStream getInputStream() {
        this.checkSingleUsage();
        return this.input;
    }

    public void write(OutputStream outputStream) throws IOException, CMSException {
        this.checkSingleUsage();
        Streams.pipeAll(this.input, outputStream);
        this.input.close();
    }

    public Object getContent() {
        return this.getInputStream();
    }

    private synchronized void checkSingleUsage() {
        if (this.used) {
            throw new IllegalStateException("CMSProcessableInputStream can only be used once");
        }
        this.used = true;
    }
}

