/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.cert.crmf;

import java.io.IOException;
import shaded.org.bouncycastle.asn1.ASN1Encodable;
import shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.org.bouncycastle.asn1.ASN1Primitive;
import shaded.org.bouncycastle.asn1.DERUTF8String;
import shaded.org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import shaded.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import shaded.org.bouncycastle.asn1.crmf.CertReqMsg;
import shaded.org.bouncycastle.asn1.crmf.CertTemplate;
import shaded.org.bouncycastle.asn1.crmf.Controls;
import shaded.org.bouncycastle.asn1.crmf.PKIArchiveOptions;
import shaded.org.bouncycastle.asn1.crmf.PKMACValue;
import shaded.org.bouncycastle.asn1.crmf.POPOSigningKey;
import shaded.org.bouncycastle.asn1.crmf.ProofOfPossession;
import shaded.org.bouncycastle.cert.CertIOException;
import shaded.org.bouncycastle.cert.crmf.AuthenticatorControl;
import shaded.org.bouncycastle.cert.crmf.CRMFException;
import shaded.org.bouncycastle.cert.crmf.CRMFUtil;
import shaded.org.bouncycastle.cert.crmf.Control;
import shaded.org.bouncycastle.cert.crmf.PKIArchiveControl;
import shaded.org.bouncycastle.cert.crmf.PKMACBuilder;
import shaded.org.bouncycastle.cert.crmf.PKMACValueVerifier;
import shaded.org.bouncycastle.cert.crmf.RegTokenControl;
import shaded.org.bouncycastle.operator.ContentVerifier;
import shaded.org.bouncycastle.operator.ContentVerifierProvider;
import shaded.org.bouncycastle.operator.OperatorCreationException;
import shaded.org.bouncycastle.util.Encodable;

public class CertificateRequestMessage
implements Encodable {
    public static final int popRaVerified = 0;
    public static final int popSigningKey = 1;
    public static final int popKeyEncipherment = 2;
    public static final int popKeyAgreement = 3;
    private final CertReqMsg certReqMsg;
    private final Controls controls;

    private static CertReqMsg parseBytes(byte[] byArray) throws IOException {
        try {
            return CertReqMsg.getInstance((Object)ASN1Primitive.fromByteArray(byArray));
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public CertificateRequestMessage(byte[] byArray) throws IOException {
        this(CertificateRequestMessage.parseBytes(byArray));
    }

    public CertificateRequestMessage(CertReqMsg certReqMsg) {
        this.certReqMsg = certReqMsg;
        this.controls = certReqMsg.getCertReq().getControls();
    }

    public CertReqMsg toASN1Structure() {
        return this.certReqMsg;
    }

    public CertTemplate getCertTemplate() {
        return this.certReqMsg.getCertReq().getCertTemplate();
    }

    public boolean hasControls() {
        return this.controls != null;
    }

    public boolean hasControl(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.findControl(aSN1ObjectIdentifier) != null;
    }

    public Control getControl(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        AttributeTypeAndValue attributeTypeAndValue = this.findControl(aSN1ObjectIdentifier);
        if (attributeTypeAndValue != null) {
            if (attributeTypeAndValue.getType().equals((Object)CRMFObjectIdentifiers.id_regCtrl_pkiArchiveOptions)) {
                return new PKIArchiveControl(PKIArchiveOptions.getInstance((Object)attributeTypeAndValue.getValue()));
            }
            if (attributeTypeAndValue.getType().equals((Object)CRMFObjectIdentifiers.id_regCtrl_regToken)) {
                return new RegTokenControl((DERUTF8String)DERUTF8String.getInstance(attributeTypeAndValue.getValue()));
            }
            if (attributeTypeAndValue.getType().equals((Object)CRMFObjectIdentifiers.id_regCtrl_authenticator)) {
                return new AuthenticatorControl((DERUTF8String)DERUTF8String.getInstance(attributeTypeAndValue.getValue()));
            }
        }
        return null;
    }

    private AttributeTypeAndValue findControl(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.controls == null) {
            return null;
        }
        AttributeTypeAndValue[] attributeTypeAndValueArray = this.controls.toAttributeTypeAndValueArray();
        AttributeTypeAndValue attributeTypeAndValue = null;
        for (int i = 0; i != attributeTypeAndValueArray.length; ++i) {
            if (!attributeTypeAndValueArray[i].getType().equals((Object)aSN1ObjectIdentifier)) continue;
            attributeTypeAndValue = attributeTypeAndValueArray[i];
            break;
        }
        return attributeTypeAndValue;
    }

    public boolean hasProofOfPossession() {
        return this.certReqMsg.getPopo() != null;
    }

    public int getProofOfPossessionType() {
        return this.certReqMsg.getPopo().getType();
    }

    public boolean hasSigningKeyProofOfPossessionWithPKMAC() {
        ProofOfPossession proofOfPossession = this.certReqMsg.getPopo();
        if (proofOfPossession.getType() == 1) {
            POPOSigningKey pOPOSigningKey = POPOSigningKey.getInstance((Object)proofOfPossession.getObject());
            return pOPOSigningKey.getPoposkInput().getPublicKeyMAC() != null;
        }
        return false;
    }

    public boolean isValidSigningKeyPOP(ContentVerifierProvider contentVerifierProvider) throws CRMFException, IllegalStateException {
        ProofOfPossession proofOfPossession = this.certReqMsg.getPopo();
        if (proofOfPossession.getType() == 1) {
            POPOSigningKey pOPOSigningKey = POPOSigningKey.getInstance((Object)proofOfPossession.getObject());
            if (pOPOSigningKey.getPoposkInput() != null && pOPOSigningKey.getPoposkInput().getPublicKeyMAC() != null) {
                throw new IllegalStateException("verification requires password check");
            }
            return this.verifySignature(contentVerifierProvider, pOPOSigningKey);
        }
        throw new IllegalStateException("not Signing Key type of proof of possession");
    }

    public boolean isValidSigningKeyPOP(ContentVerifierProvider contentVerifierProvider, PKMACBuilder pKMACBuilder, char[] cArray) throws CRMFException, IllegalStateException {
        ProofOfPossession proofOfPossession = this.certReqMsg.getPopo();
        if (proofOfPossession.getType() == 1) {
            POPOSigningKey pOPOSigningKey = POPOSigningKey.getInstance((Object)proofOfPossession.getObject());
            if (pOPOSigningKey.getPoposkInput() == null || pOPOSigningKey.getPoposkInput().getSender() != null) {
                throw new IllegalStateException("no PKMAC present in proof of possession");
            }
            PKMACValueVerifier pKMACValueVerifier = new PKMACValueVerifier(pKMACBuilder);
            PKMACValue pKMACValue = pOPOSigningKey.getPoposkInput().getPublicKeyMAC();
            if (pKMACValueVerifier.isValid(pKMACValue, cArray, this.getCertTemplate().getPublicKey())) {
                return this.verifySignature(contentVerifierProvider, pOPOSigningKey);
            }
            return false;
        }
        throw new IllegalStateException("not Signing Key type of proof of possession");
    }

    private boolean verifySignature(ContentVerifierProvider contentVerifierProvider, POPOSigningKey pOPOSigningKey) throws CRMFException {
        ContentVerifier contentVerifier;
        try {
            contentVerifier = contentVerifierProvider.get(pOPOSigningKey.getAlgorithmIdentifier());
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CRMFException("unable to create verifier: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        if (pOPOSigningKey.getPoposkInput() != null) {
            CRMFUtil.derEncodeToStream((ASN1Encodable)pOPOSigningKey.getPoposkInput(), contentVerifier.getOutputStream());
        } else {
            CRMFUtil.derEncodeToStream((ASN1Encodable)this.certReqMsg.getCertReq(), contentVerifier.getOutputStream());
        }
        return contentVerifier.verify(pOPOSigningKey.getSignature().getOctets());
    }

    public byte[] getEncoded() throws IOException {
        return this.certReqMsg.getEncoded();
    }
}

