/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Hashtable;
import shaded.cfca.sadk.algorithm.common.Mechanism;
import shaded.cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import shaded.cfca.sadk.algorithm.common.PKIException;
import shaded.cfca.sadk.algorithm.sm2.SM2HashZValue;
import shaded.cfca.sadk.algorithm.sm2.SM3Digest;
import shaded.cfca.sadk.lib.crypto.jni.JNIDigest;
import shaded.cfca.sadk.lib.crypto.jni.JNISM2;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERNull;
import shaded.cfca.sadk.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.DigestInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.crypto.ExtendedDigest;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.MD5Digest;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.SHA512Digest;
import shaded.cfca.sadk.system.global.FileAndBufferConfig;

public class HashUtil {
    public static final Hashtable ALGOIDMAP = new Hashtable();

    public static byte[] RSAHashMessageByBC(byte[] sourceData, Mechanism mechanism, boolean ifDEREncoding) throws PKIException {
        byte[] outData = null;
        if (sourceData == null || sourceData.length == 0) {
            throw new PKIException("the source data is null or empty!");
        }
        try {
            ExtendedDigest extDigest = HashUtil.getDigestByBC(mechanism);
            extDigest.update(sourceData, 0, sourceData.length);
            outData = new byte[extDigest.getDigestSize()];
            extDigest.doFinal(outData, 0);
            if (!ifDEREncoding) {
                return outData;
            }
            AlgorithmIdentifier algId = new AlgorithmIdentifier((ASN1ObjectIdentifier)ALGOIDMAP.get(mechanism.getMechanismType()), DERNull.INSTANCE);
            DigestInfo dInfo = new DigestInfo(algId, outData);
            outData = dInfo.getEncoded("DER");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outData;
    }

    public static byte[] RSAHashMessageByJNI(byte[] sourceData, Mechanism mechanism, boolean ifDEREncoding) throws Exception {
        byte[] outData = null;
        if (sourceData == null || sourceData.length == 0) {
            throw new PKIException("the source data is null or empty!");
        }
        try {
            JNIDigest jniDigest = HashUtil.getDigestByJNI(mechanism);
            jniDigest.update(sourceData);
            outData = new byte[jniDigest.getDigestSize()];
            jniDigest.doFinal(outData);
            if (!ifDEREncoding) {
                return outData;
            }
            AlgorithmIdentifier algId = new AlgorithmIdentifier((ASN1ObjectIdentifier)ALGOIDMAP.get(mechanism.getMechanismType()), DERNull.INSTANCE);
            DigestInfo dInfo = new DigestInfo(algId, outData);
            outData = dInfo.getEncoded("DER");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outData;
    }

    public static byte[] RSAHashFileByBC(InputStream sourceStream, Mechanism mechanism, boolean ifDEREncoding) throws PKIException {
        BufferedInputStream bufferedInputStream = null;
        ExtendedDigest digest = HashUtil.getDigestByBC(mechanism);
        bufferedInputStream = new BufferedInputStream(sourceStream);
        int buffer_size = FileAndBufferConfig.BIG_FILE_BUFFER;
        byte[] buffer = new byte[buffer_size];
        try {
            int i = bufferedInputStream.read(buffer);
            if (i == -1) {
                throw new PKIException("the source data is null!");
            }
            do {
                digest.update(buffer, 0, i);
            } while ((i = bufferedInputStream.read(buffer)) != -1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] out = new byte[digest.getDigestSize()];
        digest.doFinal(out, 0);
        if (!ifDEREncoding) {
            return out;
        }
        AlgorithmIdentifier algId = new AlgorithmIdentifier((ASN1ObjectIdentifier)ALGOIDMAP.get(mechanism.getMechanismType()), DERNull.INSTANCE);
        DigestInfo dInfo = new DigestInfo(algId, out);
        try {
            out = dInfo.getEncoded("DER");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    public static byte[] RSAHashFileByJNI(InputStream sourceStream, Mechanism mechanism, boolean ifDEREncoding) throws Exception {
        byte[] outData = null;
        BufferedInputStream bufferedInputStream = null;
        JNIDigest jniDigest = HashUtil.getDigestByJNI(mechanism);
        bufferedInputStream = new BufferedInputStream(sourceStream);
        int buffer_size = FileAndBufferConfig.BIG_FILE_BUFFER;
        byte[] buffer = new byte[buffer_size];
        try {
            int i = bufferedInputStream.read(buffer);
            if (i == -1) {
                throw new PKIException("the source data is null!");
            }
            do {
                if (i < buffer_size) {
                    byte[] temp = new byte[i];
                    System.arraycopy(buffer, 0, temp, 0, i);
                    jniDigest.update(temp);
                    break;
                }
                jniDigest.update(buffer);
            } while ((i = bufferedInputStream.read(buffer)) != -1);
            outData = new byte[jniDigest.getDigestSize()];
            jniDigest.doFinal(outData);
            if (!ifDEREncoding) {
                return outData;
            }
            AlgorithmIdentifier algId = new AlgorithmIdentifier((ASN1ObjectIdentifier)ALGOIDMAP.get(mechanism.getMechanismType()), DERNull.INSTANCE);
            DigestInfo dInfo = new DigestInfo(algId, outData);
            outData = dInfo.getEncoded("DER");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outData;
    }

    private static ExtendedDigest getDigestByBC(Mechanism mechanism) throws PKIException {
        String type = mechanism.getMechanismType();
        if (type.equals("SHA-1") || type.equals("sha1WithRSAEncryption")) {
            return new SHA1Digest();
        }
        if (type.equals("SHA-256") || type.equals("sha256WithRSAEncryption")) {
            return new SHA256Digest();
        }
        if (type.equals("SHA-512") || type.equals("sha512WithRSAEncryption")) {
            return new SHA512Digest();
        }
        if (type.equals("MD5") || type.equals("md5WithRSAEncryption")) {
            return new MD5Digest();
        }
        throw new PKIException("can not support this algorithm:" + type);
    }

    private static JNIDigest getDigestByJNI(Mechanism mechanism) throws Exception {
        String type = mechanism.getMechanismType();
        JNIDigest jniDigest = new JNIDigest();
        if (type.equals("SHA-1") || type.equals("sha1WithRSAEncryption")) {
            jniDigest.init(64);
        } else if (type.equals("SHA-256") || type.equals("sha256WithRSAEncryption")) {
            jniDigest.init(672);
        } else if (type.equals("SHA-512") || type.equals("sha512WithRSAEncryption")) {
            jniDigest.init(674);
        } else if (type.equals("MD5") || type.equals("md5WithRSAEncryption")) {
            jniDigest.init(4);
        } else {
            throw new PKIException("can not support this algorithm:" + type);
        }
        return jniDigest;
    }

    public static byte[] SM2HashMessageByBCWithoutZValue(byte[] sourceData) throws Exception {
        byte[] out = new byte[32];
        SM3Digest digest = new SM3Digest();
        digest.update(sourceData, 0, sourceData.length);
        digest.doFinal(out, 0);
        return out;
    }

    public static byte[] SM2HashMessageByBCWithZValue(byte[] userId, byte[] sourceData, BigInteger pubX, BigInteger pubY) throws PKIException {
        if (sourceData == null || sourceData.length == 0) {
            throw new PKIException("the source data is null or empty!");
        }
        byte[] out = new byte[32];
        byte[] z = SM2HashZValue.getZa(pubX, pubY, userId);
        SM3Digest digest = new SM3Digest();
        digest.update(z, 0, z.length);
        digest.update(sourceData, 0, sourceData.length);
        digest.doFinal(out, 0);
        return out;
    }

    public static byte[] SM2HashMessageByJNIWithZValue(byte[] userId, byte[] sourceData, byte[] pubX, byte[] pubY) throws PKIException {
        if (sourceData == null || sourceData.length == 0) {
            throw new PKIException("the source data is null or empty!");
        }
        byte[] out = new byte[32];
        byte[] z = new byte[32];
        try {
            JNISM2.calculateZValue(pubX, pubY, userId, z);
            JNIDigest sm3_jni = new JNIDigest();
            sm3_jni.init(922);
            sm3_jni.update(z);
            sm3_jni.update(sourceData);
            sm3_jni.doFinal(out);
            return out;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static byte[] SM2HashFileByBCWithZValue(byte[] userId, InputStream sourceStream, BigInteger pubX, BigInteger pubY) throws PKIException {
        BufferedInputStream bufferedInputStream = null;
        byte[] out = new byte[32];
        try {
            byte[] z = new byte[32];
            bufferedInputStream = new BufferedInputStream(sourceStream);
            int buffer_size = FileAndBufferConfig.BIG_FILE_BUFFER;
            byte[] buffer = new byte[buffer_size];
            int i = bufferedInputStream.read(buffer);
            z = SM2HashZValue.getZa(pubX, pubY, userId);
            SM3Digest digest = new SM3Digest();
            digest.update(z, 0, z.length);
            if (i == -1) {
                throw new Exception("the source data is null!");
            }
            do {
                digest.update(buffer, 0, i);
            } while ((i = bufferedInputStream.read(buffer)) != -1);
            digest.doFinal(out, 0);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
        return out;
    }

    public static byte[] SM2HashFileByJNIWithZValue(byte[] userId, InputStream sourceStream, byte[] pubX, byte[] pubY) throws PKIException {
        BufferedInputStream bfis = null;
        byte[] out = new byte[32];
        try {
            byte[] z = new byte[32];
            bfis = new BufferedInputStream(sourceStream);
            int buffer_size = FileAndBufferConfig.BIG_FILE_BUFFER;
            byte[] buffer = new byte[buffer_size];
            int i = bfis.read(buffer);
            JNISM2.calculateZValue(pubX, pubY, userId, z);
            JNIDigest sm3_jni = new JNIDigest();
            sm3_jni.init(922);
            sm3_jni.update(z);
            if (i == -1) {
                throw new Exception("the source data is null!");
            }
            do {
                if (i < buffer_size) {
                    byte[] temp = new byte[i];
                    System.arraycopy(buffer, 0, temp, 0, i);
                    sm3_jni.update(temp);
                    break;
                }
                sm3_jni.update(buffer);
            } while ((i = bfis.read(buffer)) != -1);
            sm3_jni.doFinal(out);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            if (bfis != null) {
                try {
                    bfis.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
        return out;
    }

    public static byte[] SM2HashMessageByJNIWithoutZValue(byte[] sourceData) throws Exception {
        byte[] out = new byte[32];
        JNIDigest sm3_jni = new JNIDigest();
        sm3_jni.init(922);
        sm3_jni.update(sourceData);
        sm3_jni.doFinal(out);
        return out;
    }

    public static byte[] SM2HashFileByBCWithoutZValue(InputStream sourceStream) throws Exception {
        byte[] out = new byte[32];
        BufferedInputStream bfis = null;
        try {
            bfis = new BufferedInputStream(sourceStream);
            int buffer_size = FileAndBufferConfig.BIG_FILE_BUFFER;
            byte[] buffer = new byte[buffer_size];
            int i = bfis.read(buffer);
            SM3Digest digest = null;
            if (i == -1) {
                throw new Exception("the source data is null!");
            }
            digest = new SM3Digest();
            do {
                digest.update(buffer, 0, i);
            } while ((i = bfis.read(buffer)) != -1);
            digest.doFinal(out, 0);
            byte[] byArray = out;
            return byArray;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            if (bfis != null) {
                bfis.close();
            }
        }
    }

    public static byte[] SM2HashFileByJNIWithoutZValue(InputStream sourceStream) throws Exception {
        byte[] out = new byte[32];
        BufferedInputStream bfis = null;
        try {
            bfis = new BufferedInputStream(sourceStream);
            int buffer_size = FileAndBufferConfig.BIG_FILE_BUFFER;
            byte[] buffer = new byte[buffer_size];
            int i = bfis.read(buffer);
            JNIDigest sm3_jni = null;
            if (i == -1) {
                throw new Exception("the source data is null!");
            }
            sm3_jni = new JNIDigest();
            sm3_jni.init(922);
            do {
                if (i < buffer_size) {
                    byte[] temp = new byte[i];
                    System.arraycopy(buffer, 0, temp, 0, i);
                    sm3_jni.update(temp);
                    break;
                }
                sm3_jni.update(buffer);
            } while ((i = bfis.read(buffer)) != -1);
            sm3_jni.doFinal(out);
            byte[] byArray = out;
            return byArray;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            if (bfis != null) {
                bfis.close();
            }
        }
    }

    static {
        ALGOIDMAP.put("RIPEMD128", TeleTrusTObjectIdentifiers.ripemd128);
        ALGOIDMAP.put("RIPEMD160", TeleTrusTObjectIdentifiers.ripemd160);
        ALGOIDMAP.put("RIPEMD256", TeleTrusTObjectIdentifiers.ripemd256);
        ALGOIDMAP.put("SHA-1", X509ObjectIdentifiers.id_SHA1);
        ALGOIDMAP.put("sha1WithRSAEncryption", X509ObjectIdentifiers.id_SHA1);
        ALGOIDMAP.put("SHA-244", NISTObjectIdentifiers.id_sha224);
        ALGOIDMAP.put("SHA-256", NISTObjectIdentifiers.id_sha256);
        ALGOIDMAP.put("sha256WithRSAEncryption", NISTObjectIdentifiers.id_sha256);
        ALGOIDMAP.put("SHA-384", NISTObjectIdentifiers.id_sha384);
        ALGOIDMAP.put("SHA-512", NISTObjectIdentifiers.id_sha512);
        ALGOIDMAP.put("sha512WithRSAEncryption", NISTObjectIdentifiers.id_sha512);
        ALGOIDMAP.put("MD2", PKCSObjectIdentifiers.md2);
        ALGOIDMAP.put("MD4", PKCSObjectIdentifiers.md4);
        ALGOIDMAP.put("MD5", PKCSObjectIdentifiers.md5);
        ALGOIDMAP.put("md5WithRSAEncryption", PKCSObjectIdentifiers.md5);
    }
}

