/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.signature.sm2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.security.PublicKey;
import shaded.cfca.sadk.algorithm.sm2.SM2HashZValue;
import shaded.cfca.sadk.algorithm.sm2.SM2PublicKey;
import shaded.cfca.sadk.algorithm.sm2.SM3Digest;
import shaded.cfca.sadk.algorithm.util.FileUtil;
import shaded.cfca.sadk.lib.crypto.Session;
import shaded.cfca.sadk.lib.crypto.jni.JNIDigest;
import shaded.cfca.sadk.lib.crypto.jni.JNISoftLib;
import shaded.cfca.sadk.system.global.FileAndBufferConfig;

public class SM2HashUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hashFile(boolean ifZValue, byte[] userId, String sourceFilePath, long startPos, long dataLength, PublicKey pubKey, String generate_sourceFilePath, Session session) throws Exception {
        RandomAccessFile bfis = null;
        FileOutputStream gen_fos = null;
        try {
            byte[] out = new byte[32];
            bfis = new RandomAccessFile(new File(sourceFilePath), "r");
            if (generate_sourceFilePath != null && !generate_sourceFilePath.trim().equals("")) {
                gen_fos = new FileOutputStream(generate_sourceFilePath);
            }
            bfis.seek(startPos);
            int buffer_size = FileAndBufferConfig.BIG_FILE_BUFFER;
            byte[] buffer = new byte[buffer_size];
            long readTotalLen = 0L;
            SM3Digest digest = null;
            JNIDigest sm3_jni = null;
            if (session instanceof JNISoftLib) {
                sm3_jni = new JNIDigest();
                sm3_jni.init(922);
            } else {
                digest = new SM3Digest();
            }
            if (ifZValue) {
                SM2PublicKey key = (SM2PublicKey)pubKey;
                byte[] z = SM2HashZValue.getZa(key.getQ().getX().toBigInteger(), key.getQ().getY().toBigInteger(), userId);
                SM2HashUtil.update(sm3_jni, digest, z, 0, z.length, false, null, session);
            }
            if (dataLength > (long)FileAndBufferConfig.BIG_FILE_BUFFER) {
                int readLen;
                while ((readLen = bfis.read(buffer)) > 0 && readTotalLen < dataLength) {
                    if (readTotalLen + (long)readLen <= dataLength) {
                        readTotalLen += (long)readLen;
                        SM2HashUtil.update(sm3_jni, digest, buffer, 0, readLen, false, null, session);
                        FileUtil.writeBytesToFile(buffer, 0, readLen, gen_fos);
                        continue;
                    }
                    int left = (int)(dataLength - readTotalLen);
                    SM2HashUtil.update(sm3_jni, digest, buffer, 0, left, false, null, session);
                    FileUtil.writeBytesToFile(buffer, 0, left, gen_fos);
                    break;
                }
            } else {
                buffer = new byte[(int)dataLength];
                int i = bfis.read(buffer);
                SM2HashUtil.update(sm3_jni, digest, buffer, 0, i, false, null, session);
                FileUtil.writeBytesToFile(buffer, 0, i, gen_fos);
            }
            SM2HashUtil.update(sm3_jni, digest, buffer, 0, 0, true, out, session);
            byte[] byArray = out;
            return byArray;
        }
        finally {
            if (bfis != null) {
                bfis.close();
            }
            if (gen_fos != null) {
                gen_fos.close();
            }
        }
    }

    private static void update(JNIDigest sm3_jni, SM3Digest digest, byte[] data, int pos, int len, boolean dofinal, byte[] out, Session session) throws Exception {
        if (session instanceof JNISoftLib) {
            if (dofinal) {
                sm3_jni.doFinal(out);
            } else {
                byte[] temp = new byte[len];
                System.arraycopy(data, 0, temp, 0, len);
                sm3_jni.update(temp);
            }
        } else if (dofinal) {
            digest.doFinal(out, 0);
        } else {
            digest.update(data, pos, len);
        }
    }
}

