/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.tsp.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import shaded.cfca.sadk.org.bouncycastle.operator.DigestCalculator;

class SHA256DigestCalculator
implements DigestCalculator {
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

    SHA256DigestCalculator() {
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
    }

    public OutputStream getOutputStream() {
        return this.bOut;
    }

    public byte[] getDigest() {
        byte[] bytes = this.bOut.toByteArray();
        this.bOut.reset();
        SHA256Digest sha256 = new SHA256Digest();
        sha256.update(bytes, 0, bytes.length);
        byte[] digest = new byte[sha256.getDigestSize()];
        sha256.doFinal(digest, 0);
        return digest;
    }
}

