/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.operator.bc;

import java.security.SecureRandom;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.crypto.Wrapper;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ParametersWithRandom;
import shaded.cfca.sadk.org.bouncycastle.operator.GenericKey;
import shaded.cfca.sadk.org.bouncycastle.operator.OperatorException;
import shaded.cfca.sadk.org.bouncycastle.operator.SymmetricKeyWrapper;
import shaded.cfca.sadk.org.bouncycastle.operator.bc.OperatorUtils;

public class BcSymmetricKeyWrapper
extends SymmetricKeyWrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyWrapper(AlgorithmIdentifier wrappingAlgorithm, Wrapper wrapper, KeyParameter wrappingKey) {
        super(wrappingAlgorithm);
        this.wrapper = wrapper;
        this.wrappingKey = wrappingKey;
    }

    public BcSymmetricKeyWrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        byte[] contentEncryptionKeySpec = OperatorUtils.getKeyBytes(encryptionKey);
        if (this.random == null) {
            this.wrapper.init(true, this.wrappingKey);
        } else {
            this.wrapper.init(true, new ParametersWithRandom(this.wrappingKey, this.random));
        }
        return this.wrapper.wrap(contentEncryptionKeySpec, 0, contentEncryptionKeySpec.length);
    }
}

