/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.openssl.test;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import shaded.cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import shaded.cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import shaded.cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.cfca.sadk.org.bouncycastle.openssl.PEMDecryptorProvider;
import shaded.cfca.sadk.org.bouncycastle.openssl.PEMEncryptedKeyPair;
import shaded.cfca.sadk.org.bouncycastle.openssl.PEMKeyPair;
import shaded.cfca.sadk.org.bouncycastle.openssl.PEMParser;
import shaded.cfca.sadk.org.bouncycastle.openssl.PEMWriter;
import shaded.cfca.sadk.org.bouncycastle.openssl.PasswordFinder;
import shaded.cfca.sadk.org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import shaded.cfca.sadk.org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import shaded.cfca.sadk.org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import shaded.cfca.sadk.org.bouncycastle.operator.InputDecryptorProvider;
import shaded.cfca.sadk.org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class ParserTest
extends SimpleTest {
    public String getName() {
        return "PEMParserTest";
    }

    private PEMParser openPEMResource(String fileName) {
        InputStream res = this.getClass().getResourceAsStream(fileName);
        BufferedReader fRd = new BufferedReader(new InputStreamReader(res));
        return new PEMParser(fRd);
    }

    public void performTest() throws Exception {
        Object privInfo;
        ASN1ObjectIdentifier ecOID;
        X9ECParameters ecSpec;
        Object o;
        PEMParser pemRd = this.openPEMResource("test.pem");
        while ((o = pemRd.readObject()) != null) {
            if (!(o instanceof KeyPair)) continue;
        }
        pemRd = this.openPEMResource("extratest.pem");
        while ((o = pemRd.readObject()) != null) {
            if (o instanceof X509CertificateHolder) continue;
            this.fail("wrong object found");
        }
        pemRd = this.openPEMResource("pkcs7.pem");
        ContentInfo d = (ContentInfo)pemRd.readObject();
        if (!d.getContentType().equals(CMSObjectIdentifiers.envelopedData)) {
            this.fail("failed envelopedData check");
        }
        if ((ecSpec = ECNamedCurveTable.getByOID(ecOID = (ASN1ObjectIdentifier)(pemRd = this.openPEMResource("eckey.pem")).readObject())) == null) {
            this.fail("ecSpec not found for named curve");
        }
        PEMKeyPair pemPair = (PEMKeyPair)pemRd.readObject();
        KeyPair pair = new JcaPEMKeyConverter().setProvider("BC").getKeyPair(pemPair);
        Signature sgr = Signature.getInstance("ECDSA", "BC");
        sgr.initSign(pair.getPrivate());
        byte[] message = new byte[]{97, 98, 99};
        sgr.update(message);
        byte[] sigBytes = sgr.sign();
        sgr.initVerify(pair.getPublic());
        sgr.update(message);
        if (!sgr.verify(sigBytes)) {
            this.fail("EC verification failed");
        }
        if (!pair.getPublic().getAlgorithm().equals("ECDSA")) {
            this.fail("wrong algorithm name on public got: " + pair.getPublic().getAlgorithm());
        }
        if (!pair.getPrivate().getAlgorithm().equals("ECDSA")) {
            this.fail("wrong algorithm name on private");
        }
        pemRd = this.openPEMResource("ecexpparam.pem");
        ecSpec = (X9ECParameters)pemRd.readObject();
        pemPair = (PEMKeyPair)pemRd.readObject();
        pair = new JcaPEMKeyConverter().setProvider("BC").getKeyPair(pemPair);
        sgr = Signature.getInstance("ECDSA", "BC");
        sgr.initSign(pair.getPrivate());
        message = new byte[]{97, 98, 99};
        sgr.update(message);
        sigBytes = sgr.sign();
        sgr.initVerify(pair.getPublic());
        sgr.update(message);
        if (!sgr.verify(sigBytes)) {
            this.fail("EC verification failed");
        }
        if (!pair.getPublic().getAlgorithm().equals("ECDSA")) {
            this.fail("wrong algorithm name on public got: " + pair.getPublic().getAlgorithm());
        }
        if (!pair.getPrivate().getAlgorithm().equals("ECDSA")) {
            this.fail("wrong algorithm name on private");
        }
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        pair = kpGen.generateKeyPair();
        this.keyPairTest("RSA", pair);
        kpGen = KeyPairGenerator.getInstance("DSA", "BC");
        kpGen.initialize(512, new SecureRandom());
        pair = kpGen.generateKeyPair();
        this.keyPairTest("DSA", pair);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PEMWriter pWrt = new PEMWriter(new OutputStreamWriter(bOut));
        pWrt.writeObject(d);
        pWrt.close();
        pemRd = new PEMParser(new InputStreamReader(new ByteArrayInputStream(bOut.toByteArray())));
        d = (ContentInfo)pemRd.readObject();
        if (!d.getContentType().equals(CMSObjectIdentifiers.envelopedData)) {
            this.fail("failed envelopedData recode check");
        }
        this.doOpenSslDsaTest("unencrypted");
        this.doOpenSslRsaTest("unencrypted");
        this.doOpenSslTests("aes128");
        this.doOpenSslTests("aes192");
        this.doOpenSslTests("aes256");
        this.doOpenSslTests("blowfish");
        this.doOpenSslTests("des1");
        this.doOpenSslTests("des2");
        this.doOpenSslTests("des3");
        this.doOpenSslTests("rc2_128");
        this.doOpenSslDsaTest("rc2_40_cbc");
        this.doOpenSslRsaTest("rc2_40_cbc");
        this.doOpenSslDsaTest("rc2_64_cbc");
        this.doOpenSslRsaTest("rc2_64_cbc");
        this.doDudPasswordTest("7fd98", 0, "corrupted stream - out of bounds length found");
        this.doDudPasswordTest("ef677", 1, "corrupted stream - out of bounds length found");
        this.doDudPasswordTest("800ce", 2, "unknown tag 26 encountered");
        this.doDudPasswordTest("b6cd8", 3, "DEF length 81 object truncated by 56");
        this.doDudPasswordTest("28ce09", 4, "DEF length 110 object truncated by 28");
        this.doDudPasswordTest("2ac3b9", 5, "DER length more than 4 bytes: 11");
        this.doDudPasswordTest("2cba96", 6, "DEF length 100 object truncated by 35");
        this.doDudPasswordTest("2e3354", 7, "DEF length 42 object truncated by 9");
        this.doDudPasswordTest("2f4142", 8, "DER length more than 4 bytes: 14");
        this.doDudPasswordTest("2fe9bb", 9, "DER length more than 4 bytes: 65");
        this.doDudPasswordTest("3ee7a8", 10, "DER length more than 4 bytes: 57");
        this.doDudPasswordTest("41af75", 11, "unknown tag 16 encountered");
        this.doDudPasswordTest("1704a5", 12, "corrupted stream detected");
        this.doDudPasswordTest("1c5822", 13, "unknown object in getInstance: org.bouncycastle.asn1.DERUTF8String");
        this.doDudPasswordTest("5a3d16", 14, "corrupted stream detected");
        this.doDudPasswordTest("8d0c97", 15, "corrupted stream detected");
        this.doDudPasswordTest("bc0daf", 16, "corrupted stream detected");
        this.doDudPasswordTest("aaf9c4d", 17, "corrupted stream - out of bounds length found");
        this.doNoPasswordTest();
        InputDecryptorProvider pkcs8Prov = new JceOpenSSLPKCS8DecryptorProviderBuilder().build("password".toCharArray());
        pemRd = this.openPEMResource("enckey.pem");
        PKCS8EncryptedPrivateKeyInfo encPrivKeyInfo = (PKCS8EncryptedPrivateKeyInfo)pemRd.readObject();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        RSAPrivateCrtKey privKey = (RSAPrivateCrtKey)converter.getPrivateKey(encPrivKeyInfo.decryptPrivateKeyInfo(pkcs8Prov));
        if (!privKey.getPublicExponent().equals(new BigInteger("10001", 16))) {
            this.fail("decryption of private key data check failed");
        }
        pemRd = this.openPEMResource("pkcs8test.pem");
        while ((privInfo = pemRd.readObject()) != null) {
            privKey = privInfo instanceof PrivateKeyInfo ? (RSAPrivateCrtKey)converter.getPrivateKey(PrivateKeyInfo.getInstance(privInfo)) : (RSAPrivateCrtKey)converter.getPrivateKey(((PKCS8EncryptedPrivateKeyInfo)privInfo).decryptPrivateKeyInfo(pkcs8Prov));
            if (privKey.getPublicExponent().equals(new BigInteger("10001", 16))) continue;
            this.fail("decryption of private key data check failed");
        }
    }

    private void keyPairTest(String name, KeyPair pair) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PEMWriter pWrt = new PEMWriter(new OutputStreamWriter(bOut));
        pWrt.writeObject(pair.getPublic());
        pWrt.close();
        PEMParser pemRd = new PEMParser(new InputStreamReader(new ByteArrayInputStream(bOut.toByteArray())));
        SubjectPublicKeyInfo pub = SubjectPublicKeyInfo.getInstance(pemRd.readObject());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        PublicKey k = converter.getPublicKey(pub);
        if (!k.equals(pair.getPublic())) {
            this.fail("Failed public key read: " + name);
        }
        bOut = new ByteArrayOutputStream();
        pWrt = new PEMWriter(new OutputStreamWriter(bOut));
        pWrt.writeObject(pair.getPrivate());
        pWrt.close();
        pemRd = new PEMParser(new InputStreamReader(new ByteArrayInputStream(bOut.toByteArray())));
        KeyPair kPair = converter.getKeyPair((PEMKeyPair)pemRd.readObject());
        if (!kPair.getPrivate().equals(pair.getPrivate())) {
            this.fail("Failed private key read: " + name);
        }
        if (!kPair.getPublic().equals(pair.getPublic())) {
            this.fail("Failed private key public read: " + name);
        }
    }

    private void doOpenSslTests(String baseName) throws IOException {
        this.doOpenSslDsaModesTest(baseName);
        this.doOpenSslRsaModesTest(baseName);
    }

    private void doOpenSslDsaModesTest(String baseName) throws IOException {
        this.doOpenSslDsaTest(baseName + "_cbc");
        this.doOpenSslDsaTest(baseName + "_cfb");
        this.doOpenSslDsaTest(baseName + "_ecb");
        this.doOpenSslDsaTest(baseName + "_ofb");
    }

    private void doOpenSslRsaModesTest(String baseName) throws IOException {
        this.doOpenSslRsaTest(baseName + "_cbc");
        this.doOpenSslRsaTest(baseName + "_cfb");
        this.doOpenSslRsaTest(baseName + "_ecb");
        this.doOpenSslRsaTest(baseName + "_ofb");
    }

    private void doOpenSslDsaTest(String name) throws IOException {
        String fileName = "dsa/openssl_dsa_" + name + ".pem";
        this.doOpenSslTestFile(fileName, DSAPrivateKey.class);
    }

    private void doOpenSslRsaTest(String name) throws IOException {
        String fileName = "rsa/openssl_rsa_" + name + ".pem";
        this.doOpenSslTestFile(fileName, RSAPrivateKey.class);
    }

    private void doOpenSslTestFile(String fileName, Class expectedPrivKeyClass) throws IOException {
        KeyPair kp;
        PrivateKey privKey;
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().setProvider("BC").build("changeit".toCharArray());
        PEMParser pr = this.openPEMResource("data/" + fileName);
        Object o = pr.readObject();
        if (o == null || !(o instanceof PEMKeyPair) && !(o instanceof PEMEncryptedKeyPair)) {
            this.fail("Didn't find OpenSSL key");
        }
        if (!expectedPrivKeyClass.isInstance(privKey = (kp = o instanceof PEMEncryptedKeyPair ? converter.getKeyPair(((PEMEncryptedKeyPair)o).decryptKeyPair(decProv)) : converter.getKeyPair((PEMKeyPair)o)).getPrivate())) {
            this.fail("Returned key not of correct type");
        }
    }

    private void doDudPasswordTest(String password, int index, String message) {
        block4: {
            try {
                Object o;
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().setProvider("BC").build(password.toCharArray());
                PEMParser pemRd = this.openPEMResource("test.pem");
                while ((o = pemRd.readObject()) != null) {
                    if (!(o instanceof PEMEncryptedKeyPair)) continue;
                    ((PEMEncryptedKeyPair)o).decryptKeyPair(decProv);
                }
                this.fail("issue not detected: " + index);
            }
            catch (IOException e) {
                if (e.getCause() != null && !e.getCause().getMessage().endsWith(message)) {
                    this.fail("issue " + index + " exception thrown, but wrong message");
                }
                if (e.getCause() != null || e.getMessage().equals(message)) break block4;
                e.printStackTrace();
                this.fail("issue " + index + " exception thrown, but wrong message");
            }
        }
    }

    private void doNoPasswordTest() throws IOException {
        Object o;
        PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().setProvider("BC").build("".toCharArray());
        PEMParser pemRd = this.openPEMResource("smimenopw.pem");
        PrivateKeyInfo key = null;
        while ((o = pemRd.readObject()) != null) {
            key = (PrivateKeyInfo)o;
        }
        if (key == null) {
            this.fail("private key not detected");
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        ParserTest.runTest(new ParserTest());
    }

    private static class Password
    implements PasswordFinder {
        char[] password;

        Password(char[] word) {
            this.password = word;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

