/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.openssl.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import shaded.cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERSequence;
import shaded.cfca.sadk.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.PBES2Parameters;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import shaded.cfca.sadk.org.bouncycastle.jcajce.util.JcaJceHelper;
import shaded.cfca.sadk.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import shaded.cfca.sadk.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import shaded.cfca.sadk.org.bouncycastle.openssl.jcajce.PEMUtilities;
import shaded.cfca.sadk.org.bouncycastle.operator.GenericKey;
import shaded.cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import shaded.cfca.sadk.org.bouncycastle.operator.OutputEncryptor;
import shaded.cfca.sadk.org.bouncycastle.operator.jcajce.JceGenericKey;

public class JceOpenSSLPKCS8EncryptorBuilder {
    public static final String AES_128_CBC = NISTObjectIdentifiers.id_aes128_CBC.getId();
    public static final String AES_192_CBC = NISTObjectIdentifiers.id_aes192_CBC.getId();
    public static final String AES_256_CBC = NISTObjectIdentifiers.id_aes256_CBC.getId();
    public static final String DES3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC.getId();
    public static final String PBE_SHA1_RC4_128 = PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4.getId();
    public static final String PBE_SHA1_RC4_40 = PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4.getId();
    public static final String PBE_SHA1_3DES = PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC.getId();
    public static final String PBE_SHA1_2DES = PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC.getId();
    public static final String PBE_SHA1_RC2_128 = PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC.getId();
    public static final String PBE_SHA1_RC2_40 = PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC.getId();
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private AlgorithmParameters params;
    private ASN1ObjectIdentifier algOID;
    byte[] salt;
    int iterationCount;
    private Cipher cipher;
    private SecureRandom random;
    private AlgorithmParameterGenerator paramGen;
    private SecretKeyFactory secKeyFact;
    private char[] password;
    private SecretKey key;

    public JceOpenSSLPKCS8EncryptorBuilder(ASN1ObjectIdentifier algorithm) {
        this.algOID = algorithm;
        this.iterationCount = 2048;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setPasssword(char[] password) {
        this.password = password;
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public OutputEncryptor build() throws OperatorCreationException {
        AlgorithmIdentifier algID;
        this.salt = new byte[20];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(this.salt);
        try {
            this.cipher = this.helper.createCipher(this.algOID.getId());
            if (PEMUtilities.isPKCS5Scheme2(this.algOID)) {
                this.paramGen = this.helper.createAlgorithmParameterGenerator(this.algOID.getId());
            } else {
                this.secKeyFact = this.helper.createSecretKeyFactory(this.algOID.getId());
            }
        }
        catch (GeneralSecurityException e) {
            throw new OperatorCreationException(this.algOID + " not available: " + e.getMessage(), e);
        }
        if (PEMUtilities.isPKCS5Scheme2(this.algOID)) {
            this.params = this.paramGen.generateParameters();
            try {
                KeyDerivationFunc scheme = new KeyDerivationFunc(this.algOID, ASN1Primitive.fromByteArray(this.params.getEncoded()));
                KeyDerivationFunc func = new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(this.salt, this.iterationCount));
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add(func);
                v.add(scheme);
                algID = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, PBES2Parameters.getInstance(new DERSequence(v)));
            }
            catch (IOException e) {
                throw new OperatorCreationException(e.getMessage(), e);
            }
            this.key = PEMUtilities.generateSecretKeyForPKCS5Scheme2(this.algOID.getId(), this.password, this.salt, this.iterationCount);
            try {
                this.cipher.init(1, (Key)this.key, this.params);
            }
            catch (GeneralSecurityException e) {
                throw new OperatorCreationException(e.getMessage(), e);
            }
        }
        if (PEMUtilities.isPKCS12(this.algOID)) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new DEROctetString(this.salt));
            v.add(new ASN1Integer(this.iterationCount));
            algID = new AlgorithmIdentifier(this.algOID, PKCS12PBEParams.getInstance(new DERSequence(v)));
            try {
                PBEKeySpec pbeSpec = new PBEKeySpec(this.password);
                PBEParameterSpec defParams = new PBEParameterSpec(this.salt, this.iterationCount);
                this.key = this.secKeyFact.generateSecret(pbeSpec);
                this.cipher.init(1, (Key)this.key, defParams);
            }
            catch (GeneralSecurityException e) {
                throw new OperatorCreationException(e.getMessage(), e);
            }
        } else {
            throw new OperatorCreationException("unknown algorithm: " + this.algOID, null);
        }
        return new OutputEncryptor(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algID;
            }

            public OutputStream getOutputStream(OutputStream encOut) {
                return new CipherOutputStream(encOut, JceOpenSSLPKCS8EncryptorBuilder.this.cipher);
            }

            public GenericKey getKey() {
                return new JceGenericKey(algID, JceOpenSSLPKCS8EncryptorBuilder.this.key);
            }
        };
    }
}

