/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.util;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.GOST3410Parameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.GOST3410PublicKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.jce.interfaces.GOST3410PrivateKey;
import shaded.cfca.sadk.org.bouncycastle.jce.interfaces.GOST3410PublicKey;
import shaded.cfca.sadk.org.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;

public class GOST3410Util {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof GOST3410PublicKey) {
            GOST3410PublicKey k = (GOST3410PublicKey)key;
            GOST3410PublicKeyParameterSetSpec p = k.getParameters().getPublicKeyParameters();
            return new GOST3410PublicKeyParameters(k.getY(), new GOST3410Parameters(p.getP(), p.getQ(), p.getA()));
        }
        throw new InvalidKeyException("can't identify GOST3410 public key: " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof GOST3410PrivateKey) {
            GOST3410PrivateKey k = (GOST3410PrivateKey)key;
            GOST3410PublicKeyParameterSetSpec p = k.getParameters().getPublicKeyParameters();
            return new GOST3410PrivateKeyParameters(k.getX(), new GOST3410Parameters(p.getP(), p.getQ(), p.getA()));
        }
        throw new InvalidKeyException("can't identify GOST3410 private key.");
    }
}

