/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.eac;

import java.io.OutputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.DERApplicationSpecific;
import shaded.cfca.sadk.org.bouncycastle.asn1.eac.CVCertificate;
import shaded.cfca.sadk.org.bouncycastle.asn1.eac.CertificateBody;
import shaded.cfca.sadk.org.bouncycastle.asn1.eac.CertificateHolderAuthorization;
import shaded.cfca.sadk.org.bouncycastle.asn1.eac.CertificateHolderReference;
import shaded.cfca.sadk.org.bouncycastle.asn1.eac.CertificationAuthorityReference;
import shaded.cfca.sadk.org.bouncycastle.asn1.eac.PackedDate;
import shaded.cfca.sadk.org.bouncycastle.asn1.eac.PublicKeyDataObject;
import shaded.cfca.sadk.org.bouncycastle.eac.EACCertificateHolder;
import shaded.cfca.sadk.org.bouncycastle.eac.EACException;
import shaded.cfca.sadk.org.bouncycastle.eac.operator.EACSigner;

public class EACCertificateBuilder {
    private static final byte[] ZeroArray = new byte[]{0};
    private PublicKeyDataObject publicKey;
    private CertificateHolderAuthorization certificateHolderAuthorization;
    private PackedDate certificateEffectiveDate;
    private PackedDate certificateExpirationDate;
    private CertificateHolderReference certificateHolderReference;
    private CertificationAuthorityReference certificationAuthorityReference;

    public EACCertificateBuilder(CertificationAuthorityReference certificationAuthorityReference, PublicKeyDataObject publicKey, CertificateHolderReference certificateHolderReference, CertificateHolderAuthorization certificateHolderAuthorization, PackedDate certificateEffectiveDate, PackedDate certificateExpirationDate) {
        this.certificationAuthorityReference = certificationAuthorityReference;
        this.publicKey = publicKey;
        this.certificateHolderReference = certificateHolderReference;
        this.certificateHolderAuthorization = certificateHolderAuthorization;
        this.certificateEffectiveDate = certificateEffectiveDate;
        this.certificateExpirationDate = certificateExpirationDate;
    }

    private CertificateBody buildBody() {
        DERApplicationSpecific certificateProfileIdentifier = new DERApplicationSpecific(41, ZeroArray);
        CertificateBody body = new CertificateBody(certificateProfileIdentifier, this.certificationAuthorityReference, this.publicKey, this.certificateHolderReference, this.certificateHolderAuthorization, this.certificateEffectiveDate, this.certificateExpirationDate);
        return body;
    }

    public EACCertificateHolder build(EACSigner signer) throws EACException {
        try {
            CertificateBody body = this.buildBody();
            OutputStream vOut = signer.getOutputStream();
            vOut.write(body.getEncoded("DER"));
            vOut.close();
            return new EACCertificateHolder(new CVCertificate(body, signer.getSignature()));
        }
        catch (Exception e) {
            throw new EACException("unable to process signature: " + e.getMessage(), e);
        }
    }
}

