/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.dvcs;

import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.cms.SignedData;
import shaded.cfca.sadk.org.bouncycastle.asn1.dvcs.DVCSObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSSignedData;
import shaded.cfca.sadk.org.bouncycastle.dvcs.DVCSConstructionException;
import shaded.cfca.sadk.org.bouncycastle.dvcs.DVCSMessage;

public class DVCSResponse
extends DVCSMessage {
    private shaded.cfca.sadk.org.bouncycastle.asn1.dvcs.DVCSResponse asn1;

    public DVCSResponse(CMSSignedData signedData) throws DVCSConstructionException {
        this(SignedData.getInstance(signedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSResponse(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSResponseData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Request");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? shaded.cfca.sadk.org.bouncycastle.asn1.dvcs.DVCSResponse.getInstance(contentInfo.getContent()) : shaded.cfca.sadk.org.bouncycastle.asn1.dvcs.DVCSResponse.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception e) {
            throw new DVCSConstructionException("Unable to parse content: " + e.getMessage(), e);
        }
    }

    public ASN1Encodable getContent() {
        return this.asn1;
    }
}

