/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import shaded.cfca.sadk.org.bouncycastle.asn1.oiw.ElGamalParameter;
import shaded.cfca.sadk.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.DHParameter;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import shaded.cfca.sadk.org.bouncycastle.asn1.sec.ECPrivateKey;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.DSAParameter;
import shaded.cfca.sadk.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import shaded.cfca.sadk.org.bouncycastle.asn1.x9.X962Parameters;
import shaded.cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import shaded.cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import shaded.cfca.sadk.org.bouncycastle.crypto.ec.CustomNamedCurves;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.DHParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.DSAParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ElGamalParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] privateKeyInfoData) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(privateKeyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getPrivateKeyAlgorithm();
        if (algId.getAlgorithm().equals(PKCSObjectIdentifiers.rsaEncryption)) {
            RSAPrivateKey keyStructure = RSAPrivateKey.getInstance(keyInfo.parsePrivateKey());
            return new RSAPrivateCrtKeyParameters(keyStructure.getModulus(), keyStructure.getPublicExponent(), keyStructure.getPrivateExponent(), keyStructure.getPrime1(), keyStructure.getPrime2(), keyStructure.getExponent1(), keyStructure.getExponent2(), keyStructure.getCoefficient());
        }
        if (algId.getAlgorithm().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter params = DHParameter.getInstance(algId.getParameters());
            ASN1Integer derX = (ASN1Integer)keyInfo.parsePrivateKey();
            BigInteger lVal = params.getL();
            int l = lVal == null ? 0 : lVal.intValue();
            DHParameters dhParams = new DHParameters(params.getP(), params.getG(), null, l);
            return new DHPrivateKeyParameters(derX.getValue(), dhParams);
        }
        if (algId.getAlgorithm().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter params = ElGamalParameter.getInstance(algId.getParameters());
            ASN1Integer derX = (ASN1Integer)keyInfo.parsePrivateKey();
            return new ElGamalPrivateKeyParameters(derX.getValue(), new ElGamalParameters(params.getP(), params.getG()));
        }
        if (algId.getAlgorithm().equals(X9ObjectIdentifiers.id_dsa)) {
            ASN1Integer derX = (ASN1Integer)keyInfo.parsePrivateKey();
            ASN1Encodable de = algId.getParameters();
            DSAParameters parameters = null;
            if (de != null) {
                DSAParameter params = DSAParameter.getInstance(de.toASN1Primitive());
                parameters = new DSAParameters(params.getP(), params.getQ(), params.getG());
            }
            return new DSAPrivateKeyParameters(derX.getValue(), parameters);
        }
        if (algId.getAlgorithm().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            ECDomainParameters dParams;
            X962Parameters params = new X962Parameters((ASN1Primitive)algId.getParameters());
            if (params.isNamedCurve()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)params.getParameters();
                X9ECParameters x9 = CustomNamedCurves.getByOID(oid);
                if (x9 == null) {
                    x9 = ECNamedCurveTable.getByOID(oid);
                }
                dParams = new ECNamedDomainParameters(oid, x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
            } else {
                X9ECParameters x9 = X9ECParameters.getInstance(params.getParameters());
                dParams = new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
            }
            ECPrivateKey ec = ECPrivateKey.getInstance(keyInfo.parsePrivateKey());
            BigInteger d = ec.getKey();
            return new ECPrivateKeyParameters(d, dParams);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

