/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.tls.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.Certificate;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.DefaultTlsAgreementCredentials;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.DefaultTlsEncryptionCredentials;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.DefaultTlsSignerCredentials;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsAgreementCredentials;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsContext;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsSignerCredentials;
import shaded.cfca.sadk.org.bouncycastle.crypto.util.PrivateKeyFactory;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Base64;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Hex;
import shaded.cfca.sadk.org.bouncycastle.util.io.pem.PemObject;
import shaded.cfca.sadk.org.bouncycastle.util.io.pem.PemReader;

public class TlsTestUtils {
    static final byte[] rsaCertData = Base64.decode("MIICUzCCAf2gAwIBAgIBATANBgkqhkiG9w0BAQQFADCBjzELMAkGA1UEBhMCQVUxKDAmBgNVBAoMH1RoZSBMZWdpb24gb2YgdGhlIEJvdW5jeSBDYXN0bGUxEjAQBgNVBAcMCU1lbGJvdXJuZTERMA8GA1UECAwIVmljdG9yaWExLzAtBgkqhkiG9w0BCQEWIGZlZWRiYWNrLWNyeXB0b0Bib3VuY3ljYXN0bGUub3JnMB4XDTEzMDIyNTA2MDIwNVoXDTEzMDIyNTA2MDM0NVowgY8xCzAJBgNVBAYTAkFVMSgwJgYDVQQKDB9UaGUgTGVnaW9uIG9mIHRoZSBCb3VuY3kgQ2FzdGxlMRIwEAYDVQQHDAlNZWxib3VybmUxETAPBgNVBAgMCFZpY3RvcmlhMS8wLQYJKoZIhvcNAQkBFiBmZWVkYmFjay1jcnlwdG9AYm91bmN5Y2FzdGxlLm9yZzBaMA0GCSqGSIb3DQEBAQUAA0kAMEYCQQC0p+RhcFdPFqlwgrIr5YtqKmKXmEGb4ShypL26Ymz66ZAPdqv7EhOdzl3lZWT6srZUMWWgQMYGiHQg4z2R7X7XAgERo0QwQjAOBgNVHQ8BAf8EBAMCBSAwEgYDVR0lAQH/BAgwBgYEVR0lADAcBgNVHREBAf8EEjAQgQ50ZXN0QHRlc3QudGVzdDANBgkqhkiG9w0BAQQFAANBAHU55NczeglREcTg54YLUlGWu2WOYWhit/iM1eeq8Kivro7q98eW52jTuMI3CI5ulqd0hYzshQKQaZ5GDzErMyM=");
    static final byte[] dudRsaCertData = Base64.decode("MIICUzCCAf2gAwIBAgIBATANBgkqhkiG9w0BAQQFADCBjzELMAkGA1UEBhMCQVUxKDAmBgNVBAoMH1RoZSBMZWdpb24gb2YgdGhlIEJvdW5jeSBDYXN0bGUxEjAQBgNVBAcMCU1lbGJvdXJuZTERMA8GA1UECAwIVmljdG9yaWExLzAtBgkqhkiG9w0BCQEWIGZlZWRiYWNrLWNyeXB0b0Bib3VuY3ljYXN0bGUub3JnMB4XDTEzMDIyNTA1NDcyOFoXDTEzMDIyNTA1NDkwOFowgY8xCzAJBgNVBAYTAkFVMSgwJgYDVQQKDB9UaGUgTGVnaW9uIG9mIHRoZSBCb3VuY3kgQ2FzdGxlMRIwEAYDVQQHDAlNZWxib3VybmUxETAPBgNVBAgMCFZpY3RvcmlhMS8wLQYJKoZIhvcNAQkBFiBmZWVkYmFjay1jcnlwdG9AYm91bmN5Y2FzdGxlLm9yZzBaMA0GCSqGSIb3DQEBAQUAA0kAMEYCQQC0p+RhcFdPFqlwgrIr5YtqKmKXmEGb4ShypL26Ymz66ZAPdqv7EhOdzl3lZWT6srZUMWWgQMYGiHQg4z2R7X7XAgERo0QwQjAOBgNVHQ8BAf8EBAMCAAEwEgYDVR0lAQH/BAgwBgYEVR0lADAcBgNVHREBAf8EEjAQgQ50ZXN0QHRlc3QudGVzdDANBgkqhkiG9w0BAQQFAANBAJg55PBSweg6obRUKF4FF6fCrWFi6oCYSQ99LWcAeupc5BofW5MstFMhCOaEucuGVqunwT5G7/DweazzCIrSzB0=");

    static String fingerprint(shaded.cfca.sadk.org.bouncycastle.asn1.x509.Certificate c) throws IOException {
        byte[] der = c.getEncoded();
        byte[] sha1 = TlsTestUtils.sha256DigestOf(der);
        byte[] hexBytes = Hex.encode(sha1);
        String hex = new String(hexBytes, "ASCII").toUpperCase();
        StringBuffer fp = new StringBuffer();
        int i = 0;
        fp.append(hex.substring(i, i + 2));
        while ((i += 2) < hex.length()) {
            fp.append(':');
            fp.append(hex.substring(i, i + 2));
        }
        return fp.toString();
    }

    static byte[] sha256DigestOf(byte[] input) {
        SHA256Digest d = new SHA256Digest();
        d.update(input, 0, input.length);
        byte[] result = new byte[d.getDigestSize()];
        d.doFinal(result, 0);
        return result;
    }

    static TlsAgreementCredentials loadAgreementCredentials(TlsContext context, String[] certResources, String keyResource) throws IOException {
        Certificate certificate = TlsTestUtils.loadCertificateChain(certResources);
        AsymmetricKeyParameter privateKey = TlsTestUtils.loadPrivateKeyResource(keyResource);
        return new DefaultTlsAgreementCredentials(certificate, privateKey);
    }

    static TlsEncryptionCredentials loadEncryptionCredentials(TlsContext context, String[] certResources, String keyResource) throws IOException {
        Certificate certificate = TlsTestUtils.loadCertificateChain(certResources);
        AsymmetricKeyParameter privateKey = TlsTestUtils.loadPrivateKeyResource(keyResource);
        return new DefaultTlsEncryptionCredentials(context, certificate, privateKey);
    }

    static TlsSignerCredentials loadSignerCredentials(TlsContext context, String[] certResources, String keyResource, SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        Certificate certificate = TlsTestUtils.loadCertificateChain(certResources);
        AsymmetricKeyParameter privateKey = TlsTestUtils.loadPrivateKeyResource(keyResource);
        return new DefaultTlsSignerCredentials(context, certificate, privateKey, signatureAndHashAlgorithm);
    }

    static Certificate loadCertificateChain(String[] resources) throws IOException {
        shaded.cfca.sadk.org.bouncycastle.asn1.x509.Certificate[] chain = new shaded.cfca.sadk.org.bouncycastle.asn1.x509.Certificate[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            chain[i] = TlsTestUtils.loadCertificateResource(resources[i]);
        }
        return new Certificate(chain);
    }

    static shaded.cfca.sadk.org.bouncycastle.asn1.x509.Certificate loadCertificateResource(String resource) throws IOException {
        PemObject pem = TlsTestUtils.loadPemResource(resource);
        if (pem.getType().endsWith("CERTIFICATE")) {
            return shaded.cfca.sadk.org.bouncycastle.asn1.x509.Certificate.getInstance(pem.getContent());
        }
        throw new IllegalArgumentException("'resource' doesn't specify a valid certificate");
    }

    static AsymmetricKeyParameter loadPrivateKeyResource(String resource) throws IOException {
        PemObject pem = TlsTestUtils.loadPemResource(resource);
        if (pem.getType().endsWith("RSA PRIVATE KEY")) {
            RSAPrivateKey rsa = RSAPrivateKey.getInstance(pem.getContent());
            return new RSAPrivateCrtKeyParameters(rsa.getModulus(), rsa.getPublicExponent(), rsa.getPrivateExponent(), rsa.getPrime1(), rsa.getPrime2(), rsa.getExponent1(), rsa.getExponent2(), rsa.getCoefficient());
        }
        if (pem.getType().endsWith("PRIVATE KEY")) {
            return PrivateKeyFactory.createKey(pem.getContent());
        }
        throw new IllegalArgumentException("'resource' doesn't specify a valid private key");
    }

    static PemObject loadPemResource(String resource) throws IOException {
        InputStream s = TlsTestUtils.class.getResourceAsStream(resource);
        PemReader p = new PemReader(new InputStreamReader(s));
        PemObject o = p.readPemObject();
        p.close();
        return o;
    }
}

