/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.tls.test;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.Certificate;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.CertificateRequest;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.DefaultTlsClient;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.ProtocolVersion;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsAuthentication;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsCredentials;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsExtensionsUtils;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsSession;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.test.TlsTestUtils;
import shaded.cfca.sadk.org.bouncycastle.util.Arrays;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Hex;

public class MockDTLSClient
extends DefaultTlsClient {
    protected TlsSession session;

    public MockDTLSClient(TlsSession session) {
        this.session = session;
    }

    public TlsSession getSessionToResume() {
        return this.session;
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Exception cause) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("DTLS client raised alert (AlertLevel." + alertLevel + ", AlertDescription." + alertDescription + ")");
        if (message != null) {
            out.println(message);
        }
        if (cause != null) {
            cause.printStackTrace(out);
        }
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("DTLS client received alert (AlertLevel." + alertLevel + ", AlertDescription." + alertDescription + ")");
    }

    public ProtocolVersion getClientVersion() {
        return ProtocolVersion.DTLSv12;
    }

    public ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.DTLSv10;
    }

    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        TlsExtensionsUtils.addEncryptThenMACExtension(clientExtensions);
        TlsExtensionsUtils.addMaxFragmentLengthExtension(clientExtensions, (short)1);
        TlsExtensionsUtils.addTruncatedHMacExtension(clientExtensions);
        return clientExtensions;
    }

    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        super.notifyServerVersion(serverVersion);
        System.out.println("Negotiated " + serverVersion);
    }

    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            public void notifyServerCertificate(Certificate serverCertificate) throws IOException {
                shaded.cfca.sadk.org.bouncycastle.asn1.x509.Certificate[] chain = serverCertificate.getCertificateList();
                System.out.println("Received server certificate chain of length " + chain.length);
                for (int i = 0; i != chain.length; ++i) {
                    shaded.cfca.sadk.org.bouncycastle.asn1.x509.Certificate entry = chain[i];
                    System.out.println("    fingerprint:SHA-256 " + TlsTestUtils.fingerprint(entry) + " (" + entry.getSubject() + ")");
                }
            }

            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                short[] certificateTypes = certificateRequest.getCertificateTypes();
                if (certificateTypes == null || !Arrays.contains(certificateTypes, (short)1)) {
                    return null;
                }
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
                Vector sigAlgs = certificateRequest.getSupportedSignatureAlgorithms();
                if (sigAlgs != null) {
                    for (int i = 0; i < sigAlgs.size(); ++i) {
                        SignatureAndHashAlgorithm sigAlg = (SignatureAndHashAlgorithm)sigAlgs.elementAt(i);
                        if (sigAlg.getSignature() != 1) continue;
                        signatureAndHashAlgorithm = sigAlg;
                        break;
                    }
                    if (signatureAndHashAlgorithm == null) {
                        return null;
                    }
                }
                return TlsTestUtils.loadSignerCredentials(MockDTLSClient.this.context, new String[]{"x509-client.pem", "x509-ca.pem"}, "x509-client-key.pem", signatureAndHashAlgorithm);
            }
        };
    }

    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        TlsSession newSession = this.context.getResumableSession();
        if (newSession != null) {
            byte[] newSessionID = newSession.getSessionID();
            String hex = Hex.toHexString(newSessionID);
            if (this.session != null && Arrays.areEqual(this.session.getSessionID(), newSessionID)) {
                System.out.println("Resumed session: " + hex);
            } else {
                System.out.println("Established session: " + hex);
            }
            this.session = newSession;
        }
    }
}

