/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.tls.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.ProtocolVersion;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.test.DTLSTestCase;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.test.TlsTestConfig;

public class DTLSTestSuite
extends TestSuite {
    public static Test suite() {
        DTLSTestSuite testSuite = new DTLSTestSuite();
        DTLSTestSuite.addVersionTests(testSuite, ProtocolVersion.DTLSv10);
        DTLSTestSuite.addVersionTests(testSuite, ProtocolVersion.DTLSv12);
        return testSuite;
    }

    private static void addVersionTests(TestSuite testSuite, ProtocolVersion version) {
        String prefix = version.toString().replaceAll("[ \\.]", "") + "_";
        TlsTestConfig c = DTLSTestSuite.createDTLSTestConfig(version);
        testSuite.addTest((Test)new DTLSTestCase(c, prefix + "GoodDefault"));
        c = DTLSTestSuite.createDTLSTestConfig(version);
        c.serverCertReq = 0;
        testSuite.addTest((Test)new DTLSTestCase(c, prefix + "GoodNoCertReq"));
        c = DTLSTestSuite.createDTLSTestConfig(version);
        c.clientAuth = 0;
        testSuite.addTest((Test)new DTLSTestCase(c, prefix + "GoodOptionalCertReqDeclined"));
    }

    private static TlsTestConfig createDTLSTestConfig(ProtocolVersion version) {
        TlsTestConfig c = new TlsTestConfig();
        c.clientMinimumVersion = ProtocolVersion.DTLSv10;
        c.clientOfferVersion = version;
        c.serverMaximumVersion = version;
        c.serverMinimumVersion = ProtocolVersion.DTLSv10;
        return c;
    }

    static abstract class C
    extends TlsTestConfig {
        C() {
        }
    }
}

