/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.tls.test;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.security.SecureRandom;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.DTLSServerProtocol;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.DTLSTransport;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.UDPTransport;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.test.MockDTLSServer;

public class DTLSServerTest {
    public static void main(String[] args) throws Exception {
        InetAddress address = InetAddress.getLocalHost();
        int port = 5556;
        int mtu = 1500;
        SecureRandom secureRandom = new SecureRandom();
        DTLSServerProtocol serverProtocol = new DTLSServerProtocol(secureRandom);
        byte[] data = new byte[mtu];
        DatagramPacket packet = new DatagramPacket(data, mtu);
        DatagramSocket socket = new DatagramSocket(port, address);
        socket.receive(packet);
        System.out.println("Accepting connection from " + packet.getAddress().getHostAddress() + ":" + port);
        socket.connect(packet.getAddress(), packet.getPort());
        UDPTransport transport = new UDPTransport(socket, mtu);
        MockDTLSServer server = new MockDTLSServer();
        DTLSTransport dtlsServer = serverProtocol.accept(server, transport);
        byte[] buf = new byte[dtlsServer.getReceiveLimit()];
        while (!socket.isClosed()) {
            try {
                int length = dtlsServer.receive(buf, 0, buf.length, 60000);
                if (length < 0) continue;
                System.out.write(buf, 0, length);
                dtlsServer.send(buf, 0, length);
            }
            catch (SocketTimeoutException ste) {}
        }
        dtlsServer.close();
    }
}

