/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.tls.test;

import java.security.SecureRandom;
import junit.framework.TestCase;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.DTLSClientProtocol;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.DTLSServerProtocol;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.DTLSTransport;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.DatagramTransport;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.test.LoggingDatagramTransport;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.test.MockDTLSClient;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.test.MockDTLSServer;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.test.MockDatagramAssociation;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.test.UnreliableDatagramTransport;
import shaded.cfca.sadk.org.bouncycastle.util.Arrays;

public class DTLSProtocolTest
extends TestCase {
    public void testClientServer() throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        DTLSClientProtocol clientProtocol = new DTLSClientProtocol(secureRandom);
        DTLSServerProtocol serverProtocol = new DTLSServerProtocol(secureRandom);
        MockDatagramAssociation network = new MockDatagramAssociation(1500);
        ServerThread serverThread = new ServerThread(serverProtocol, network.getServer());
        serverThread.start();
        DatagramTransport clientTransport = network.getClient();
        clientTransport = new UnreliableDatagramTransport(clientTransport, secureRandom, 0, 0);
        clientTransport = new LoggingDatagramTransport(clientTransport, System.out);
        MockDTLSClient client = new MockDTLSClient(null);
        DTLSTransport dtlsClient = clientProtocol.connect(client, clientTransport);
        for (int i = 1; i <= 10; ++i) {
            byte[] data = new byte[i];
            Arrays.fill(data, (byte)i);
            dtlsClient.send(data, 0, data.length);
        }
        byte[] buf = new byte[dtlsClient.getReceiveLimit()];
        while (dtlsClient.receive(buf, 0, buf.length, 100) >= 0) {
        }
        dtlsClient.close();
        serverThread.shutdown();
    }

    static class ServerThread
    extends Thread {
        private final DTLSServerProtocol serverProtocol;
        private final DatagramTransport serverTransport;
        private volatile boolean isShutdown = false;

        ServerThread(DTLSServerProtocol serverProtocol, DatagramTransport serverTransport) {
            this.serverProtocol = serverProtocol;
            this.serverTransport = serverTransport;
        }

        public void run() {
            try {
                MockDTLSServer server = new MockDTLSServer();
                DTLSTransport dtlsServer = this.serverProtocol.accept(server, this.serverTransport);
                byte[] buf = new byte[dtlsServer.getReceiveLimit()];
                while (!this.isShutdown) {
                    int length = dtlsServer.receive(buf, 0, buf.length, 1000);
                    if (length < 0) continue;
                    dtlsServer.send(buf, 0, length);
                }
                dtlsServer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void shutdown() throws InterruptedException {
            if (!this.isShutdown) {
                this.isShutdown = true;
                this.join();
            }
        }
    }
}

