/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.cfca.sadk.org.bouncycastle.crypto.agreement.DHBasicAgreement;
import shaded.cfca.sadk.org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.DHParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.ServerDHParams;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsFatalAlert;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsUtils;
import shaded.cfca.sadk.org.bouncycastle.util.BigIntegers;

public class TlsDHUtils {
    static final BigInteger ONE = BigInteger.valueOf(1L);
    static final BigInteger TWO = BigInteger.valueOf(2L);

    public static boolean areCompatibleParameters(DHParameters a, DHParameters b) {
        return a.getP().equals(b.getP()) && a.getG().equals(b.getG());
    }

    public static byte[] calculateDHBasicAgreement(DHPublicKeyParameters publicKey, DHPrivateKeyParameters privateKey) {
        DHBasicAgreement basicAgreement = new DHBasicAgreement();
        basicAgreement.init(privateKey);
        BigInteger agreementValue = basicAgreement.calculateAgreement(publicKey);
        return BigIntegers.asUnsignedByteArray(agreementValue);
    }

    public static AsymmetricCipherKeyPair generateDHKeyPair(SecureRandom random, DHParameters dhParams) {
        DHBasicKeyPairGenerator dhGen = new DHBasicKeyPairGenerator();
        dhGen.init(new DHKeyGenerationParameters(random, dhParams));
        return dhGen.generateKeyPair();
    }

    public static DHPrivateKeyParameters generateEphemeralClientKeyExchange(SecureRandom random, DHParameters dhParams, OutputStream output) throws IOException {
        AsymmetricCipherKeyPair kp = TlsDHUtils.generateDHKeyPair(random, dhParams);
        DHPublicKeyParameters dh_public = (DHPublicKeyParameters)kp.getPublic();
        TlsDHUtils.writeDHParameter(dh_public.getY(), output);
        return (DHPrivateKeyParameters)kp.getPrivate();
    }

    public static DHPrivateKeyParameters generateEphemeralServerKeyExchange(SecureRandom random, DHParameters dhParams, OutputStream output) throws IOException {
        AsymmetricCipherKeyPair kp = TlsDHUtils.generateDHKeyPair(random, dhParams);
        DHPublicKeyParameters dhPublicKey = (DHPublicKeyParameters)kp.getPublic();
        ServerDHParams params = new ServerDHParams(dhPublicKey);
        params.encode(output);
        return (DHPrivateKeyParameters)kp.getPrivate();
    }

    public static DHPublicKeyParameters validateDHPublicKey(DHPublicKeyParameters key) throws IOException {
        BigInteger Y = key.getY();
        DHParameters params = key.getParameters();
        BigInteger p = params.getP();
        BigInteger g = params.getG();
        if (!p.isProbablePrime(2)) {
            throw new TlsFatalAlert(47);
        }
        if (g.compareTo(TWO) < 0 || g.compareTo(p.subtract(TWO)) > 0) {
            throw new TlsFatalAlert(47);
        }
        if (Y.compareTo(TWO) < 0 || Y.compareTo(p.subtract(ONE)) > 0) {
            throw new TlsFatalAlert(47);
        }
        return key;
    }

    public static BigInteger readDHParameter(InputStream input) throws IOException {
        return new BigInteger(1, TlsUtils.readOpaque16(input));
    }

    public static void writeDHParameter(BigInteger x, OutputStream output) throws IOException {
        TlsUtils.writeOpaque16(BigIntegers.asUnsignedByteArray(x), output);
    }
}

