/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.tls;

import java.io.IOException;
import shaded.cfca.sadk.org.bouncycastle.crypto.CryptoException;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.AbstractTlsSignerCredentials;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.Certificate;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsContext;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsDSSSigner;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsECDSASigner;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsFatalAlert;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsRSASigner;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsSigner;
import shaded.cfca.sadk.org.bouncycastle.crypto.tls.TlsUtils;

public class DefaultTlsSignerCredentials
extends AbstractTlsSignerCredentials {
    protected TlsContext context;
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;
    protected SignatureAndHashAlgorithm signatureAndHashAlgorithm;
    protected TlsSigner signer;

    public DefaultTlsSignerCredentials(TlsContext context, Certificate certificate, AsymmetricKeyParameter privateKey) {
        this(context, certificate, privateKey, null);
    }

    public DefaultTlsSignerCredentials(TlsContext context, Certificate certificate, AsymmetricKeyParameter privateKey, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (TlsUtils.isTLSv12(context) && signatureAndHashAlgorithm == null) {
            throw new IllegalArgumentException("'signatureAndHashAlgorithm' cannot be null for (D)TLS 1.2+");
        }
        if (privateKey instanceof RSAKeyParameters) {
            this.signer = new TlsRSASigner();
        } else if (privateKey instanceof DSAPrivateKeyParameters) {
            this.signer = new TlsDSSSigner();
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            this.signer = new TlsECDSASigner();
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.signer.init(context);
        this.context = context;
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public byte[] generateCertificateSignature(byte[] hash) throws IOException {
        try {
            if (TlsUtils.isTLSv12(this.context)) {
                return this.signer.generateRawSignature(this.signatureAndHashAlgorithm, this.privateKey, hash);
            }
            return this.signer.generateRawSignature(this.privateKey, hash);
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80);
        }
    }

    public SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
        return this.signatureAndHashAlgorithm;
    }
}

