/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import shaded.cfca.sadk.org.bouncycastle.asn1.sec.SECNamedCurves;
import shaded.cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import shaded.cfca.sadk.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import shaded.cfca.sadk.org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import shaded.cfca.sadk.org.bouncycastle.crypto.kems.ECIESKeyEncapsulation;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class ECIESKeyEncapsulationTest
extends SimpleTest {
    public String getName() {
        return "ECIESKeyEncapsulation";
    }

    public void performTest() throws Exception {
        X9ECParameters spec = SECNamedCurves.getByName("secp224r1");
        ECDomainParameters ecDomain = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN());
        ECKeyPairGenerator ecGen = new ECKeyPairGenerator();
        ecGen.init(new ECKeyGenerationParameters(ecDomain, new SecureRandom()));
        AsymmetricCipherKeyPair keys = ecGen.generateKeyPair();
        KDF2BytesGenerator kdf = new KDF2BytesGenerator(new SHA1Digest());
        SecureRandom rnd = new SecureRandom();
        byte[] out = new byte[57];
        ECIESKeyEncapsulation kem = new ECIESKeyEncapsulation(kdf, rnd);
        kem.init(keys.getPublic());
        KeyParameter key1 = (KeyParameter)kem.encrypt(out, 128);
        kem.init(keys.getPrivate());
        KeyParameter key2 = (KeyParameter)kem.decrypt(out, 128);
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed basic test");
        }
        kem = new ECIESKeyEncapsulation(kdf, rnd, true, false, false);
        kem.init(keys.getPublic());
        key1 = (KeyParameter)kem.encrypt(out, 128);
        kem.init(keys.getPrivate());
        key2 = (KeyParameter)kem.decrypt(out, 128);
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed cofactor test");
        }
        kem = new ECIESKeyEncapsulation(kdf, rnd, false, true, false);
        kem.init(keys.getPublic());
        key1 = (KeyParameter)kem.encrypt(out, 128);
        kem.init(keys.getPrivate());
        key2 = (KeyParameter)kem.decrypt(out, 128);
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed old cofactor test");
        }
        kem = new ECIESKeyEncapsulation(kdf, rnd, false, false, true);
        kem.init(keys.getPublic());
        key1 = (KeyParameter)kem.encrypt(out, 128);
        kem.init(keys.getPrivate());
        key2 = (KeyParameter)kem.decrypt(out, 128);
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed single hash test");
        }
        kem = new ECIESKeyEncapsulation(kdf, rnd, true, false, true);
        kem.init(keys.getPublic());
        key1 = (KeyParameter)kem.encrypt(out, 128);
        kem.init(keys.getPrivate());
        key2 = (KeyParameter)kem.decrypt(out, 128);
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed cofactor and single hash test");
        }
        kem = new ECIESKeyEncapsulation(kdf, rnd, false, true, true);
        kem.init(keys.getPublic());
        key1 = (KeyParameter)kem.encrypt(out, 128);
        kem.init(keys.getPrivate());
        key2 = (KeyParameter)kem.decrypt(out, 128);
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed old cofactor and single hash test");
        }
    }

    public static void main(String[] args) {
        ECIESKeyEncapsulationTest.runTest(new ECIESKeyEncapsulationTest());
    }
}

