/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.test;

import shaded.cfca.sadk.org.bouncycastle.crypto.engines.AESEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.AESFastEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.macs.CMac;
import shaded.cfca.sadk.org.bouncycastle.crypto.macs.CMacWithIV;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Hex;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class CMacTest
extends SimpleTest {
    private static final byte[] keyBytes128 = Hex.decode("2b7e151628aed2a6abf7158809cf4f3c");
    private static final byte[] keyBytes192 = Hex.decode("8e73b0f7da0e6452c810f32b809079e562f8ead2522c6b7b");
    private static final byte[] keyBytes256 = Hex.decode("603deb1015ca71be2b73aef0857d77811f352c073b6108d72d9810a30914dff4");
    private static final byte[] input0 = Hex.decode("");
    private static final byte[] input16 = Hex.decode("6bc1bee22e409f96e93d7e117393172a");
    private static final byte[] input40 = Hex.decode("6bc1bee22e409f96e93d7e117393172aae2d8a571e03ac9c9eb76fac45af8e5130c81c46a35ce411");
    private static final byte[] input64 = Hex.decode("6bc1bee22e409f96e93d7e117393172aae2d8a571e03ac9c9eb76fac45af8e5130c81c46a35ce411e5fbc1191a0a52eff69f2445df4f9b17ad2b417be66c3710");
    private static final byte[] output_k128_m0 = Hex.decode("bb1d6929e95937287fa37d129b756746");
    private static final byte[] output_k128_m16 = Hex.decode("070a16b46b4d4144f79bdd9dd04a287c");
    private static final byte[] output_k128_m40 = Hex.decode("dfa66747de9ae63030ca32611497c827");
    private static final byte[] output_k128_m64 = Hex.decode("51f0bebf7e3b9d92fc49741779363cfe");
    private static final byte[] output_k192_m0 = Hex.decode("d17ddf46adaacde531cac483de7a9367");
    private static final byte[] output_k192_m16 = Hex.decode("9e99a7bf31e710900662f65e617c5184");
    private static final byte[] output_k192_m40 = Hex.decode("8a1de5be2eb31aad089a82e6ee908b0e");
    private static final byte[] output_k192_m64 = Hex.decode("a1d5df0eed790f794d77589659f39a11");
    private static final byte[] output_k256_m0 = Hex.decode("028962f61b7bf89efc6b551f4667d983");
    private static final byte[] output_k256_m16 = Hex.decode("28a7023f452e8f82bd4bf28d8c37c35c");
    private static final byte[] output_k256_m40 = Hex.decode("aaf3d8f1de5640c232f5b169b9c911e6");
    private static final byte[] output_k256_m64 = Hex.decode("e1992190549f6ed5696a2c056c315410");

    public void performTest() {
        AESFastEngine cipher = new AESFastEngine();
        CMac mac = new CMac(cipher, 128);
        KeyParameter key = new KeyParameter(keyBytes128);
        mac.init(key);
        mac.update(input0, 0, input0.length);
        byte[] out = new byte[16];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output_k128_m0)) {
            this.fail("Failed - expected " + new String(Hex.encode(output_k128_m0)) + " got " + new String(Hex.encode(out)));
        }
        mac.init(key);
        mac.update(input16, 0, input16.length);
        out = new byte[16];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output_k128_m16)) {
            this.fail("Failed - expected " + new String(Hex.encode(output_k128_m16)) + " got " + new String(Hex.encode(out)));
        }
        mac.init(key);
        mac.update(input40, 0, input40.length);
        out = new byte[16];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output_k128_m40)) {
            this.fail("Failed - expected " + new String(Hex.encode(output_k128_m40)) + " got " + new String(Hex.encode(out)));
        }
        mac.init(key);
        mac.update(input64, 0, input64.length);
        out = new byte[16];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output_k128_m64)) {
            this.fail("Failed - expected " + new String(Hex.encode(output_k128_m64)) + " got " + new String(Hex.encode(out)));
        }
        key = new KeyParameter(keyBytes192);
        mac.init(key);
        mac.update(input0, 0, input0.length);
        out = new byte[16];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output_k192_m0)) {
            this.fail("Failed - expected " + new String(Hex.encode(output_k192_m0)) + " got " + new String(Hex.encode(out)));
        }
        mac.init(key);
        mac.update(input16, 0, input16.length);
        out = new byte[16];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output_k192_m16)) {
            this.fail("Failed - expected " + new String(Hex.encode(output_k192_m16)) + " got " + new String(Hex.encode(out)));
        }
        mac.init(key);
        mac.update(input40, 0, input40.length);
        out = new byte[16];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output_k192_m40)) {
            this.fail("Failed - expected " + new String(Hex.encode(output_k192_m40)) + " got " + new String(Hex.encode(out)));
        }
        mac.init(key);
        mac.update(input64, 0, input64.length);
        out = new byte[16];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output_k192_m64)) {
            this.fail("Failed - expected " + new String(Hex.encode(output_k192_m64)) + " got " + new String(Hex.encode(out)));
        }
        key = new KeyParameter(keyBytes256);
        mac.init(key);
        mac.update(input0, 0, input0.length);
        out = new byte[16];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output_k256_m0)) {
            this.fail("Failed - expected " + new String(Hex.encode(output_k256_m0)) + " got " + new String(Hex.encode(out)));
        }
        mac.init(key);
        mac.update(input16, 0, input16.length);
        out = new byte[16];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output_k256_m16)) {
            this.fail("Failed - expected " + new String(Hex.encode(output_k256_m16)) + " got " + new String(Hex.encode(out)));
        }
        mac.init(key);
        mac.update(input40, 0, input40.length);
        out = new byte[16];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output_k256_m40)) {
            this.fail("Failed - expected " + new String(Hex.encode(output_k256_m40)) + " got " + new String(Hex.encode(out)));
        }
        mac.init(key);
        mac.update(input64, 0, input64.length);
        out = new byte[16];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output_k256_m64)) {
            this.fail("Failed - expected " + new String(Hex.encode(output_k256_m64)) + " got " + new String(Hex.encode(out)));
        }
        mac = new CMacWithIV(new AESFastEngine());
        mac.init(key);
        mac.update(input16, 0, input16.length);
        out = new byte[16];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output_k256_m16)) {
            this.fail("Failed - expected " + new String(Hex.encode(output_k256_m16)) + " got " + new String(Hex.encode(out)));
        }
        mac = new CMacWithIV(new AESFastEngine());
        mac.init(new ParametersWithIV(key, Hex.decode("000102030405060708090a0b0c0d0e0f")));
        mac.update(input16, 0, input16.length);
        out = new byte[16];
        mac.doFinal(out, 0);
        if (this.areEqual(out, output_k256_m16)) {
            this.fail("Failed - got " + new String(Hex.encode(output_k256_m16)));
        }
        if (!this.areEqual(out, Hex.decode("9347a60c64061b9ff2a92522ca8e08fc"))) {
            this.fail("Failed - expected 9347a60c64061b9ff2a92522ca8e08fc got " + new String(Hex.encode(out)));
        }
        this.testExceptions();
    }

    private void testExceptions() {
        try {
            CMac mac = new CMac(new AESEngine());
            mac.init(new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
            this.fail("CMac does not accept IV");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public String getName() {
        return "CMac";
    }

    public static void main(String[] args) {
        CMacTest.runTest(new CMacTest());
    }
}

