/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.test;

import shaded.cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.DataLengthException;
import shaded.cfca.sadk.org.bouncycastle.crypto.InvalidCipherTextException;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.AESEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.AESFastEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.AESLightEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.BlowfishEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.CAST5Engine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.CAST6Engine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.DESEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.DESedeEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.NoekeonEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.RC6Engine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.SEEDEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.SerpentEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.TEAEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.TwofishEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.XTEAEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.modes.CFBBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.modes.GOFBBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.modes.OFBBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.modes.PGPCFBBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.modes.SICBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import shaded.cfca.sadk.org.bouncycastle.util.Arrays;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Hex;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class BlockCipherResetTest
extends SimpleTest {
    public String getName() {
        return "Block Cipher Reset";
    }

    public void performTest() throws Exception {
        this.testReset("AESFastEngine", new AESFastEngine(), new AESFastEngine(), new KeyParameter(new byte[16]));
        this.testReset("AESEngine", new AESEngine(), new AESEngine(), new KeyParameter(new byte[16]));
        this.testReset("AESLightEngine", new AESLightEngine(), new AESLightEngine(), new KeyParameter(new byte[16]));
        this.testReset("Twofish", new TwofishEngine(), new TwofishEngine(), new KeyParameter(new byte[16]));
        this.testReset("NoekeonEngine", new NoekeonEngine(), new NoekeonEngine(), new KeyParameter(new byte[16]));
        this.testReset("SerpentEngine", new SerpentEngine(), new SerpentEngine(), new KeyParameter(new byte[16]));
        this.testReset("SEEDEngine", new SEEDEngine(), new SEEDEngine(), new KeyParameter(new byte[16]));
        this.testReset("CAST6Engine", new CAST6Engine(), new CAST6Engine(), new KeyParameter(new byte[16]));
        this.testReset("RC6Engine", new RC6Engine(), new RC6Engine(), new KeyParameter(new byte[16]));
        this.testReset("DESEngine", new DESEngine(), new DESEngine(), new KeyParameter(new byte[8]));
        this.testReset("BlowfishEngine", new BlowfishEngine(), new BlowfishEngine(), new KeyParameter(new byte[8]));
        this.testReset("CAST5Engine", new CAST5Engine(), new CAST5Engine(), new KeyParameter(new byte[8]));
        this.testReset("DESedeEngine", new DESedeEngine(), new DESedeEngine(), new KeyParameter(new byte[24]));
        this.testReset("TEAEngine", new TEAEngine(), new TEAEngine(), new KeyParameter(new byte[16]));
        this.testReset("XTEAEngine", new XTEAEngine(), new XTEAEngine(), new KeyParameter(new byte[16]));
        this.testModeReset("AES/CBC", new CBCBlockCipher(new AESEngine()), new CBCBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        this.testModeReset("AES/SIC", new SICBlockCipher(new AESEngine()), new SICBlockCipher(new AESEngine()), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        this.testModeReset("AES/CFB", new CFBBlockCipher(new AESEngine(), 128), new CFBBlockCipher(new AESEngine(), 128), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        this.testModeReset("AES/OFB", new OFBBlockCipher(new AESEngine(), 128), new OFBBlockCipher(new AESEngine(), 128), new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]));
        this.testModeReset("AES/GCTR", new GOFBBlockCipher(new DESEngine()), new GOFBBlockCipher(new DESEngine()), new ParametersWithIV(new KeyParameter(new byte[8]), new byte[8]));
        this.testModeReset("AES/OpenPGPCFB", new OpenPGPCFBBlockCipher(new AESEngine()), new OpenPGPCFBBlockCipher(new AESEngine()), new KeyParameter(new byte[16]));
        this.testModeReset("AES/PGPCFB", new PGPCFBBlockCipher(new AESEngine(), false), new PGPCFBBlockCipher(new AESEngine(), false), new KeyParameter(new byte[16]));
    }

    private void testModeReset(String test, BlockCipher cipher1, BlockCipher cipher2, CipherParameters params) throws InvalidCipherTextException {
        this.testReset(test, false, cipher1, cipher2, params);
    }

    private void testReset(String test, BlockCipher cipher1, BlockCipher cipher2, CipherParameters params) throws InvalidCipherTextException {
        this.testReset(test, true, cipher1, cipher2, params);
    }

    private void testReset(String test, boolean testCryptReset, BlockCipher cipher1, BlockCipher cipher2, CipherParameters params) throws InvalidCipherTextException {
        cipher1.init(true, params);
        byte[] plaintext = new byte[cipher1.getBlockSize()];
        byte[] ciphertext = new byte[cipher1.getAlgorithmName().indexOf("PGPCFBwithIV") > -1 ? 2 * cipher1.getBlockSize() + 2 : cipher1.getBlockSize()];
        BlockCipherResetTest.crypt(cipher1, true, plaintext, ciphertext);
        this.checkReset(test, testCryptReset, cipher1, params, true, plaintext, ciphertext);
        cipher2.init(false, params);
        this.checkReset(test, testCryptReset, cipher2, params, false, ciphertext, plaintext);
    }

    private void checkReset(String test, boolean testCryptReset, BlockCipher cipher, CipherParameters params, boolean encrypt, byte[] pretext, byte[] posttext) throws InvalidCipherTextException {
        byte[] output = new byte[posttext.length];
        BlockCipherResetTest.crypt(cipher, encrypt, pretext, output);
        if (testCryptReset) {
            BlockCipherResetTest.crypt(cipher, encrypt, pretext, output);
            if (!Arrays.areEqual(output, posttext)) {
                this.fail(test + (encrypt ? " encrypt" : " decrypt") + " did not reset cipher.");
            }
        }
        cipher.processBlock(pretext, 0, output, 0);
        cipher.init(encrypt, params);
        try {
            BlockCipherResetTest.crypt(cipher, encrypt, pretext, output);
        }
        catch (DataLengthException e) {
            this.fail(test + " init did not reset data.");
        }
        if (!Arrays.areEqual(output, posttext)) {
            this.fail(test + " init did not reset data.", new String(Hex.encode(posttext)), new String(Hex.encode(output)));
        }
        cipher.processBlock(pretext, 0, output, 0);
        cipher.reset();
        try {
            BlockCipherResetTest.crypt(cipher, encrypt, pretext, output);
        }
        catch (DataLengthException e) {
            this.fail(test + " reset did not reset data.");
        }
        if (!Arrays.areEqual(output, posttext)) {
            this.fail(test + " reset did not reset data.");
        }
    }

    private static void crypt(BlockCipher cipher1, boolean encrypt, byte[] plaintext, byte[] output) throws InvalidCipherTextException {
        cipher1.processBlock(plaintext, 0, output, 0);
        if (cipher1.getAlgorithmName().indexOf("PGPCFBwithIV") > -1 && !encrypt) {
            cipher1.processBlock(plaintext, cipher1.getBlockSize(), output, 0);
        }
    }

    public static void main(String[] args) {
        BlockCipherResetTest.runTest(new BlockCipherResetTest());
    }
}

