/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.test;

import shaded.cfca.sadk.org.bouncycastle.crypto.DataLengthException;
import shaded.cfca.sadk.org.bouncycastle.crypto.InvalidCipherTextException;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.AESWrapEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import shaded.cfca.sadk.org.bouncycastle.util.Arrays;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Hex;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTestResult;
import shaded.cfca.sadk.org.bouncycastle.util.test.Test;
import shaded.cfca.sadk.org.bouncycastle.util.test.TestResult;

public class AESWrapTest
implements Test {
    public String getName() {
        return "AESWrap";
    }

    private TestResult wrapTest(int id, byte[] kek, byte[] in, byte[] out) {
        byte[] cText;
        byte[] pText;
        AESWrapEngine wrapper = new AESWrapEngine();
        wrapper.init(true, new KeyParameter(kek));
        try {
            byte[] cText2 = wrapper.wrap(in, 0, in.length);
            if (!Arrays.areEqual(cText2, out)) {
                return new SimpleTestResult(false, this.getName() + ": failed wrap test " + id + " expected " + new String(Hex.encode(out)) + " got " + new String(Hex.encode(cText2)));
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": failed wrap test exception " + e.toString());
        }
        wrapper.init(false, new KeyParameter(kek));
        try {
            pText = wrapper.unwrap(out, 0, out.length);
            if (!Arrays.areEqual(pText, in)) {
                return new SimpleTestResult(false, this.getName() + ": failed unwrap test " + id + " expected " + new String(Hex.encode(in)) + " got " + new String(Hex.encode(pText)));
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": failed unwrap test exception.", e);
        }
        pText = new byte[5 + in.length];
        System.arraycopy(in, 0, pText, 5, in.length);
        wrapper.init(true, new KeyParameter(kek));
        try {
            cText = wrapper.wrap(pText, 5, in.length);
            if (!Arrays.areEqual(cText, out)) {
                return new SimpleTestResult(false, this.getName() + ": failed wrap test " + id + " expected " + new String(Hex.encode(out)) + " got " + new String(Hex.encode(cText)));
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": failed wrap test exception " + e.toString());
        }
        wrapper.init(false, new KeyParameter(kek));
        cText = new byte[6 + out.length];
        System.arraycopy(out, 0, cText, 6, out.length);
        try {
            pText = wrapper.unwrap(cText, 6, out.length);
            if (!Arrays.areEqual(pText, in)) {
                return new SimpleTestResult(false, this.getName() + ": failed unwrap test " + id + " expected " + new String(Hex.encode(in)) + " got " + new String(Hex.encode(pText)));
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": failed unwrap test exception.", e);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        byte[] out6;
        byte[] in6;
        byte[] out5;
        byte[] in5;
        byte[] out4;
        byte[] in4;
        byte[] out3;
        byte[] in3;
        byte[] out2;
        byte[] in2;
        byte[] out1;
        byte[] in1;
        byte[] kek1 = Hex.decode("000102030405060708090a0b0c0d0e0f");
        TestResult result = this.wrapTest(1, kek1, in1 = Hex.decode("00112233445566778899aabbccddeeff"), out1 = Hex.decode("1fa68b0a8112b447aef34bd8fb5a7b829d3e862371d2cfe5"));
        if (!result.isSuccessful()) {
            return result;
        }
        byte[] kek2 = Hex.decode("000102030405060708090a0b0c0d0e0f1011121314151617");
        result = this.wrapTest(2, kek2, in2 = Hex.decode("00112233445566778899aabbccddeeff"), out2 = Hex.decode("96778b25ae6ca435f92b5b97c050aed2468ab8a17ad84e5d"));
        if (!result.isSuccessful()) {
            return result;
        }
        byte[] kek3 = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");
        result = this.wrapTest(3, kek3, in3 = Hex.decode("00112233445566778899aabbccddeeff"), out3 = Hex.decode("64e8c3f9ce0f5ba263e9777905818a2a93c8191e7d6e8ae7"));
        if (!result.isSuccessful()) {
            return result;
        }
        byte[] kek4 = Hex.decode("000102030405060708090a0b0c0d0e0f1011121314151617");
        result = this.wrapTest(4, kek4, in4 = Hex.decode("00112233445566778899aabbccddeeff0001020304050607"), out4 = Hex.decode("031d33264e15d33268f24ec260743edce1c6c7ddee725a936ba814915c6762d2"));
        if (!result.isSuccessful()) {
            return result;
        }
        byte[] kek5 = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");
        result = this.wrapTest(5, kek5, in5 = Hex.decode("00112233445566778899aabbccddeeff0001020304050607"), out5 = Hex.decode("a8f9bc1612c68b3ff6e6f4fbe30e71e4769c8b80a32cb8958cd5d17d6b254da1"));
        if (!result.isSuccessful()) {
            return result;
        }
        byte[] kek6 = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");
        result = this.wrapTest(6, kek6, in6 = Hex.decode("00112233445566778899aabbccddeeff000102030405060708090a0b0c0d0e0f"), out6 = Hex.decode("28c9f404c4b810f4cbccb35cfb87f8263f5786e2d80ed326cbc7f0e71a99f43bfb988b9b7a02dd21"));
        if (!result.isSuccessful()) {
            return result;
        }
        AESWrapEngine wrapper = new AESWrapEngine();
        KeyParameter key = new KeyParameter(new byte[16]);
        byte[] buf = new byte[16];
        try {
            wrapper.init(true, key);
            wrapper.unwrap(buf, 0, buf.length);
            return new SimpleTestResult(false, this.getName() + ": failed unwrap state test.");
        }
        catch (IllegalStateException e) {
        }
        catch (InvalidCipherTextException e) {
            return new SimpleTestResult(false, this.getName() + ": unexpected exception: " + e, e);
        }
        try {
            wrapper.init(false, key);
            wrapper.wrap(buf, 0, buf.length);
            return new SimpleTestResult(false, this.getName() + ": failed unwrap state test.");
        }
        catch (IllegalStateException e) {
            try {
                wrapper.init(false, key);
                wrapper.unwrap(buf, 0, buf.length / 2);
                return new SimpleTestResult(false, this.getName() + ": failed unwrap short test.");
            }
            catch (InvalidCipherTextException e2) {
                try {
                    wrapper.init(true, key);
                    wrapper.wrap(buf, 0, 15);
                    return new SimpleTestResult(false, this.getName() + ": failed wrap length test.");
                }
                catch (DataLengthException e3) {
                    return new SimpleTestResult(true, this.getName() + ": Okay");
                }
            }
        }
    }

    public static void main(String[] args) {
        AESWrapTest test = new AESWrapTest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

