/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import shaded.cfca.sadk.org.bouncycastle.crypto.KeyGenerationParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.GOST3410KeyGenerationParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.GOST3410Parameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.GOST3410PublicKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.math.ec.WNafUtil;

public class GOST3410KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private GOST3410KeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (GOST3410KeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger x;
        GOST3410Parameters GOST3410Params2 = this.param.getParameters();
        SecureRandom random = this.param.getRandom();
        BigInteger q = GOST3410Params2.getQ();
        BigInteger p = GOST3410Params2.getP();
        BigInteger a = GOST3410Params2.getA();
        int minWeight = 64;
        while ((x = new BigInteger(256, random)).signum() < 1 || x.compareTo(q) >= 0 || WNafUtil.getNafWeight(x) < minWeight) {
        }
        BigInteger y = a.modPow(x, p);
        return new AsymmetricCipherKeyPair(new GOST3410PublicKeyParameters(y, GOST3410Params2), new GOST3410PrivateKeyParameters(x, GOST3410Params2));
    }
}

