/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import shaded.cfca.sadk.org.bouncycastle.crypto.KeyGenerationParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.DHParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ElGamalParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters egp = this.param.getParameters();
        DHParameters dhp = new DHParameters(egp.getP(), egp.getG(), null, egp.getL());
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, egp), new ElGamalPrivateKeyParameters(x, egp));
    }
}

