/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import shaded.cfca.sadk.org.bouncycastle.crypto.KeyGenerationParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.DHParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

