/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import shaded.cfca.sadk.org.bouncycastle.crypto.CryptoException;
import shaded.cfca.sadk.org.bouncycastle.crypto.KeyGenerationParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.DESedeEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.generators.DESedeKeyGenerator;
import shaded.cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Hex;

public class DESExample {
    private boolean encrypt = true;
    private PaddedBufferedBlockCipher cipher = null;
    private BufferedInputStream in = null;
    private BufferedOutputStream out = null;
    private byte[] key = null;

    public static void main(String[] args) {
        DESExample de;
        boolean encrypt = true;
        String infile = null;
        String outfile = null;
        String keyfile = null;
        if (args.length < 2) {
            de = new DESExample();
            System.err.println("Usage: java " + de.getClass().getName() + " infile outfile [keyfile]");
            System.exit(1);
        }
        keyfile = "deskey.dat";
        infile = args[0];
        outfile = args[1];
        if (args.length > 2) {
            encrypt = false;
            keyfile = args[2];
        }
        de = new DESExample(infile, outfile, keyfile, encrypt);
        de.process();
    }

    public DESExample() {
    }

    public DESExample(String infile, String outfile, String keyfile, boolean encrypt) {
        this.encrypt = encrypt;
        try {
            this.in = new BufferedInputStream(new FileInputStream(infile));
        }
        catch (FileNotFoundException fnf) {
            System.err.println("Input file not found [" + infile + "]");
            System.exit(1);
        }
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(outfile));
        }
        catch (IOException fnf) {
            System.err.println("Output file not created [" + outfile + "]");
            System.exit(1);
        }
        if (encrypt) {
            try {
                SecureRandom sr = null;
                try {
                    sr = new SecureRandom();
                    sr.setSeed("www.bouncycastle.org".getBytes());
                }
                catch (Exception nsa) {
                    System.err.println("Hmmm, no SHA1PRNG, you need the Sun implementation");
                    System.exit(1);
                }
                KeyGenerationParameters kgp = new KeyGenerationParameters(sr, 192);
                DESedeKeyGenerator kg = new DESedeKeyGenerator();
                kg.init(kgp);
                this.key = kg.generateKey();
                BufferedOutputStream keystream = new BufferedOutputStream(new FileOutputStream(keyfile));
                byte[] keyhex = Hex.encode(this.key);
                keystream.write(keyhex, 0, keyhex.length);
                keystream.flush();
                keystream.close();
            }
            catch (IOException createKey) {
                System.err.println("Could not decryption create key file [" + keyfile + "]");
                System.exit(1);
            }
        } else {
            try {
                BufferedInputStream keystream = new BufferedInputStream(new FileInputStream(keyfile));
                int len = keystream.available();
                byte[] keyhex = new byte[len];
                keystream.read(keyhex, 0, len);
                this.key = Hex.decode(keyhex);
            }
            catch (IOException ioe) {
                System.err.println("Decryption key file not found, or not valid [" + keyfile + "]");
                System.exit(1);
            }
        }
    }

    private void process() {
        this.cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()));
        if (this.encrypt) {
            this.performEncrypt(this.key);
        } else {
            this.performDecrypt(this.key);
        }
        try {
            this.in.close();
            this.out.flush();
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void performEncrypt(byte[] key) {
        this.cipher.init(true, new KeyParameter(key));
        int inBlockSize = 47;
        int outBlockSize = this.cipher.getOutputSize(inBlockSize);
        byte[] inblock = new byte[inBlockSize];
        byte[] outblock = new byte[outBlockSize];
        try {
            int outL;
            int inL;
            byte[] rv = null;
            while ((inL = this.in.read(inblock, 0, inBlockSize)) > 0) {
                outL = this.cipher.processBytes(inblock, 0, inL, outblock, 0);
                if (outL <= 0) continue;
                rv = Hex.encode(outblock, 0, outL);
                this.out.write(rv, 0, rv.length);
                this.out.write(10);
            }
            try {
                outL = this.cipher.doFinal(outblock, 0);
                if (outL > 0) {
                    rv = Hex.encode(outblock, 0, outL);
                    this.out.write(rv, 0, rv.length);
                    this.out.write(10);
                }
            }
            catch (CryptoException ce) {}
        }
        catch (IOException ioeread) {
            ioeread.printStackTrace();
        }
    }

    private void performDecrypt(byte[] key) {
        this.cipher.init(false, new KeyParameter(key));
        BufferedReader br = new BufferedReader(new InputStreamReader(this.in));
        try {
            int outL;
            byte[] inblock = null;
            byte[] outblock = null;
            String rv = null;
            while ((rv = br.readLine()) != null) {
                inblock = Hex.decode(rv);
                outL = this.cipher.processBytes(inblock, 0, inblock.length, outblock = new byte[this.cipher.getOutputSize(inblock.length)], 0);
                if (outL <= 0) continue;
                this.out.write(outblock, 0, outL);
            }
            try {
                outL = this.cipher.doFinal(outblock, 0);
                if (outL > 0) {
                    this.out.write(outblock, 0, outL);
                }
            }
            catch (CryptoException ce) {}
        }
        catch (IOException ioeread) {
            ioeread.printStackTrace();
        }
    }
}

