/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.crypto.engines;

import java.math.BigInteger;
import shaded.cfca.sadk.org.bouncycastle.crypto.AsymmetricBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.engines.RSACoreEngine;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.ParametersWithRandom;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.RSABlindingParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;

public class RSABlindingEngine
implements AsymmetricBlockCipher {
    private RSACoreEngine core = new RSACoreEngine();
    private RSAKeyParameters key;
    private BigInteger blindingFactor;
    private boolean forEncryption;

    public void init(boolean forEncryption, CipherParameters param) {
        RSABlindingParameters p;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            p = (RSABlindingParameters)rParam.getParameters();
        } else {
            p = (RSABlindingParameters)param;
        }
        this.core.init(forEncryption, p.getPublicKey());
        this.forEncryption = forEncryption;
        this.key = p.getPublicKey();
        this.blindingFactor = p.getBlindingFactor();
    }

    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        BigInteger msg = this.core.convertInput(in, inOff, inLen);
        msg = this.forEncryption ? this.blindMessage(msg) : this.unblindMessage(msg);
        return this.core.convertOutput(msg);
    }

    private BigInteger blindMessage(BigInteger msg) {
        BigInteger blindMsg = this.blindingFactor;
        blindMsg = msg.multiply(blindMsg.modPow(this.key.getExponent(), this.key.getModulus()));
        blindMsg = blindMsg.mod(this.key.getModulus());
        return blindMsg;
    }

    private BigInteger unblindMessage(BigInteger blindedMsg) {
        BigInteger m = this.key.getModulus();
        BigInteger msg = blindedMsg;
        BigInteger blindFactorInverse = this.blindingFactor.modInverse(m);
        msg = msg.multiply(blindFactorInverse);
        msg = msg.mod(m);
        return msg;
    }
}

