/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.cms.bc;

import java.io.InputStream;
import shaded.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.cfca.sadk.org.bouncycastle.cms.CMSException;
import shaded.cfca.sadk.org.bouncycastle.cms.RecipientOperator;
import shaded.cfca.sadk.org.bouncycastle.cms.bc.BcKeyTransRecipient;
import shaded.cfca.sadk.org.bouncycastle.cms.bc.EnvelopedDataHelper;
import shaded.cfca.sadk.org.bouncycastle.crypto.BufferedBlockCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import shaded.cfca.sadk.org.bouncycastle.crypto.StreamCipher;
import shaded.cfca.sadk.org.bouncycastle.crypto.io.CipherInputStream;
import shaded.cfca.sadk.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import shaded.cfca.sadk.org.bouncycastle.operator.InputDecryptor;

public class BcRSAKeyTransEnvelopedRecipient
extends BcKeyTransRecipient {
    public BcRSAKeyTransEnvelopedRecipient(AsymmetricKeyParameter key) {
        super(key);
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        CipherParameters secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey);
        final Object dataCipher = EnvelopedDataHelper.createContentCipher(false, secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            public InputStream getInputStream(InputStream dataIn) {
                if (dataCipher instanceof BufferedBlockCipher) {
                    return new CipherInputStream(dataIn, (BufferedBlockCipher)dataCipher);
                }
                return new CipherInputStream(dataIn, (StreamCipher)dataCipher);
            }
        });
    }
}

